/*
 * Decompiled with CFR 0.152.
 */
package tools.dynamia.modules.entityfile.ui.actions;

import org.zkoss.zk.ui.Execution;
import org.zkoss.zk.ui.Executions;
import tools.dynamia.actions.ActionGroup;
import tools.dynamia.actions.InstallAction;
import tools.dynamia.actions.ReadableOnly;
import tools.dynamia.modules.entityfile.StoredEntityFile;
import tools.dynamia.modules.entityfile.domain.EntityFile;
import tools.dynamia.modules.entityfile.ui.actions.AbstractEntityFileAction;
import tools.dynamia.modules.entityfile.ui.actions.EntityFileActionEvent;
import tools.dynamia.ui.MessageType;
import tools.dynamia.ui.UIMessages;

@InstallAction
public class DownloadFileAction
extends AbstractEntityFileAction
implements ReadableOnly {
    public DownloadFileAction() {
        this.setName("Descargar Archivo");
        this.setImage("icons:download");
        this.setGroup(ActionGroup.get((String)"FILES"));
        this.setMenuSupported(true);
    }

    @Override
    public void actionPerformed(EntityFileActionEvent evt) {
        EntityFile file = evt.getEntityFile();
        if (file != null) {
            StoredEntityFile sef = file.getStoredEntityFile();
            if (sef != null && sef.getUrl() != null) {
                this.download(sef);
            } else {
                UIMessages.showMessage((String)("No se pudo encontrar archivo " + file.getName() + " en el servidor, por favor contacte con el administrador del sistema"), (MessageType)MessageType.ERROR);
            }
        } else {
            UIMessages.showMessage((String)"Seleccion archivo para descargar", (MessageType)MessageType.WARNING);
        }
    }

    private void download(StoredEntityFile sef) {
        Execution exec = Executions.getCurrent();
        exec.sendRedirect(sef.getUrl(), "_blank");
    }
}

