/*
 * Decompiled with CFR 0.152.
 */
package tools.dynamia.modules.entityfile.ui.actions;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import tools.dynamia.actions.ActionEvent;
import tools.dynamia.actions.InstallAction;
import tools.dynamia.commons.logger.LoggingService;
import tools.dynamia.commons.logger.SLF4JLoggingService;
import tools.dynamia.domain.ValidationError;
import tools.dynamia.domain.query.QueryCondition;
import tools.dynamia.domain.query.QueryConditions;
import tools.dynamia.domain.query.QueryParameters;
import tools.dynamia.domain.services.CrudService;
import tools.dynamia.domain.util.QueryBuilder;
import tools.dynamia.integration.Containers;
import tools.dynamia.integration.ProgressMonitor;
import tools.dynamia.modules.entityfile.EntityFileStorage;
import tools.dynamia.modules.entityfile.domain.EntityFile;
import tools.dynamia.modules.entityfile.domain.enums.EntityFileState;
import tools.dynamia.modules.entityfile.local.LocalEntityFileStorage;
import tools.dynamia.ui.UIMessages;
import tools.dynamia.zk.crud.cfg.AbstractConfigPageAction;
import tools.dynamia.zk.ui.LongOperationMonitorWindow;
import tools.dynamia.zk.util.LongOperation;
import tools.dynamia.zk.util.ZKUtil;

@InstallAction
class MoveEntityFileLocalToRemoteStorageAction
extends AbstractConfigPageAction {
    public static final String STORAGE_INFO = "storageInfo";
    private final CrudService crudService;
    private final LocalEntityFileStorage localStorage;
    private final LoggingService logger = new SLF4JLoggingService(MoveEntityFileLocalToRemoteStorageAction.class);

    public MoveEntityFileLocalToRemoteStorageAction(LocalEntityFileStorage localStorage, CrudService crudService) {
        this.crudService = crudService;
        this.localStorage = localStorage;
        this.setName("Move Local to Remote");
        this.setApplicableConfig("EntityFileCFG");
    }

    public void actionPerformed(ActionEvent evt) {
        Collection otherStorages = Containers.get().findObjects(EntityFileStorage.class, s -> !"LocalStorage".equals(s.getId()));
        ZKUtil.showListboxSelector((String)"Select new Storage", new ArrayList(otherStorages), event -> {
            EntityFileStorage otherStorage = event.getSelectedObjects().stream().findFirst().orElse(null);
            if (otherStorage == null) {
                return;
            }
            List<Long> accounts = this.findFilesAccounts();
            UIMessages.showQuestion((String)("Are you sure want to move files from " + accounts.size() + " accounts to " + otherStorage), () -> this.move(otherStorage, accounts, "Moving files to " + otherStorage));
        });
    }

    public void move(EntityFileStorage otherStorage, List<Long> accounts, String title) {
        ProgressMonitor monitor = new ProgressMonitor();
        LongOperation longOp = LongOperation.create().execute(() -> this.moveFiles(accounts, monitor, otherStorage)).onFinish(() -> UIMessages.showMessage((String)"Moving files completed")).onException(e -> UIMessages.showMessage((String)("Error: " + e.getMessage()))).start();
        LongOperationMonitorWindow.show((String)title, (LongOperation)longOp, (ProgressMonitor)monitor, (int)5000).setMessageTemplate("Moving files to " + otherStorage.getName() + ": {0} / {1}");
    }

    private void moveFiles(List<Long> accounts, ProgressMonitor monitor, EntityFileStorage otherStorage) {
        otherStorage.reloadParams();
        accounts.forEach(accountId -> {
            List<EntityFile> files = this.findAllLocalFiles((Long)accountId);
            monitor.setCurrent(0L);
            monitor.setMax((long)files.size());
            this.logger.info("Moving " + files.size() + " files to " + otherStorage + " account id = " + accountId);
            files.forEach(entityFile -> {
                if (monitor.isStopped()) {
                    throw new ValidationError("Moving files stoped manually");
                }
                try {
                    monitor.setCurrent(monitor.getCurrent() + 1L);
                    this.localStorage.copy(entityFile, otherStorage);
                    monitor.setMessage("Account " + accountId + ": " + entityFile.getName() + " moved");
                    this.crudService.executeWithinTransaction(() -> this.crudService.updateField(entityFile, STORAGE_INFO, (Object)otherStorage.getId()));
                }
                catch (Exception e) {
                    e.printStackTrace();
                    monitor.setMessage("Error moving entity file " + entityFile);
                }
            });
            this.logger.info("MOVING FILES COMPLETED - Account " + accountId);
        });
    }

    private List<EntityFile> findAllLocalFiles(Long accountId) {
        return this.crudService.find(EntityFile.class, QueryParameters.with((String)STORAGE_INFO, (QueryCondition)QueryConditions.eq((Object)"LocalStorage")).add("state", (Object)EntityFileState.VALID).add("accountId", (Object)accountId));
    }

    private List<Long> findFilesAccounts() {
        return this.crudService.executeQuery(QueryBuilder.select((String[])new String[]{"distinct e.accountId"}).from(EntityFile.class, "e").where(QueryParameters.with((String)STORAGE_INFO, (QueryCondition)QueryConditions.eq((Object)"LocalStorage")).add("state", (Object)EntityFileState.VALID).add("accountId", QueryConditions.isNotNull())));
    }
}

