/*
 * Decompiled with CFR 0.152.
 */
package tools.dynamia.modules.entityfile.ui.actions;

import org.springframework.beans.factory.annotation.Autowired;
import tools.dynamia.actions.ActionGroup;
import tools.dynamia.actions.InstallAction;
import tools.dynamia.modules.entityfile.enums.EntityFileType;
import tools.dynamia.modules.entityfile.service.EntityFileService;
import tools.dynamia.modules.entityfile.ui.actions.AbstractEntityFileAction;
import tools.dynamia.modules.entityfile.ui.actions.EntityFileActionEvent;
import tools.dynamia.ui.MessageType;
import tools.dynamia.ui.UIMessages;
import tools.dynamia.zk.ui.InputPanel;

@InstallAction
public class NewDirectoryAction
extends AbstractEntityFileAction {
    @Autowired
    private EntityFileService service;

    public NewDirectoryAction() {
        this.setName("Nuevo Directorio");
        this.setImage("folder2");
        this.setGroup(ActionGroup.get((String)"FILES"));
        this.setMenuSupported(true);
    }

    @Override
    public void actionPerformed(EntityFileActionEvent evt) {
        InputPanel inputPanel = new InputPanel("Nombre de Directorio", (Object)"", String.class);
        inputPanel.showDialog();
        inputPanel.addEventListener("onInput", event -> {
            String dirName = (String)event.getData();
            if (dirName != null && !dirName.isEmpty()) {
                if (evt.getEntityFile() != null && evt.getEntityFile().getType() == EntityFileType.DIRECTORY) {
                    this.service.createDirectory(evt.getEntityFile(), dirName, "");
                } else {
                    this.service.createDirectory(evt.getTargetEntity(), dirName, "");
                }
                evt.getCrudView().getController().doQuery();
            } else {
                UIMessages.showMessage((String)"Ingrese nombre del nuevo directorio", (MessageType)MessageType.ERROR);
            }
        });
    }
}

