/*
 * Decompiled with CFR 0.152.
 */
package tools.dynamia.modules.entityfile.ui.components;

import java.io.File;
import java.io.FileFilter;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import org.zkoss.zk.ui.Component;
import org.zkoss.zk.ui.event.Event;
import org.zkoss.zk.ui.event.EventListener;
import org.zkoss.zk.ui.event.Events;
import org.zkoss.zul.Tree;
import org.zkoss.zul.Treeitem;
import org.zkoss.zul.TreeitemRenderer;
import org.zkoss.zul.Window;
import tools.dynamia.io.FileInfo;
import tools.dynamia.modules.entityfile.ui.components.DirectoryTreeItemRenderer;
import tools.dynamia.modules.entityfile.ui.components.DirectoryTreeNode;
import tools.dynamia.zk.crud.ui.ChildrenLoader;
import tools.dynamia.zk.crud.ui.EntityTreeModel;
import tools.dynamia.zk.crud.ui.EntityTreeNode;
import tools.dynamia.zk.crud.ui.LazyEntityTreeNode;

public class DirectoryExplorer
extends Window
implements ChildrenLoader<FileInfo>,
EventListener<Event> {
    private String value;
    private EntityTreeModel<FileInfo> treeModel;
    private Tree tree;
    private EntityTreeNode<FileInfo> rootNode;
    private boolean showHiddenFolders;

    public DirectoryExplorer() {
        this.init();
    }

    public void reset() {
        this.initModel();
    }

    private void init() {
        this.tree = new Tree();
        this.tree.setHflex("1");
        this.tree.setVflex("1");
        this.tree.addEventListener("onClick", (EventListener)this);
        this.tree.setItemRenderer((TreeitemRenderer)new DirectoryTreeItemRenderer());
        this.appendChild((Component)this.tree);
        this.setVflex("1");
        this.setHflex("1");
        this.initModel();
    }

    private void initModel() {
        FileInfo file = new FileInfo(new File("/"));
        this.rootNode = new EntityTreeNode((Object)file);
        this.treeModel = new EntityTreeModel(this.rootNode);
        for (EntityTreeNode<FileInfo> entityTreeNode : this.getSubdirectories(file)) {
            this.rootNode.addChild(entityTreeNode);
        }
        this.tree.setModel(this.treeModel);
    }

    private Collection<EntityTreeNode<FileInfo>> getSubdirectories(FileInfo file) {
        File[] subs = file.getFile().listFiles(new FileFilter(){

            @Override
            public boolean accept(File pathname) {
                if (pathname.isDirectory()) {
                    if (!DirectoryExplorer.this.isShowHiddenFolders()) {
                        return !pathname.isHidden() && !pathname.getName().startsWith(".");
                    }
                    return true;
                }
                return false;
            }
        });
        ArrayList<EntityTreeNode<FileInfo>> subdirectories = new ArrayList<EntityTreeNode<FileInfo>>();
        if (subs != null) {
            for (File sub : subs) {
                subdirectories.add((EntityTreeNode<FileInfo>)new DirectoryTreeNode(new FileInfo(sub), this));
            }
        }
        Collections.sort(subdirectories, new Comparator<EntityTreeNode<FileInfo>>(){

            @Override
            public int compare(EntityTreeNode<FileInfo> o1, EntityTreeNode<FileInfo> o2) {
                return ((FileInfo)o1.getData()).getName().compareTo(((FileInfo)o2.getData()).getName());
            }
        });
        return subdirectories;
    }

    public void loadChildren(LazyEntityTreeNode<FileInfo> node) {
        for (EntityTreeNode<FileInfo> treeNode : this.getSubdirectories((FileInfo)node.getData())) {
            node.addChild(treeNode);
        }
    }

    public void onEvent(Event event) {
        Treeitem item = this.tree.getSelectedItem();
        if (item != null) {
            DirectoryTreeNode node = (DirectoryTreeNode)((Object)item.getValue());
            this.setValue(((FileInfo)node.getData()).getFile().getAbsolutePath());
        }
    }

    public String getValue() {
        return this.value;
    }

    public void setValue(String value) {
        this.value = value;
        Events.postEvent((Event)new Event("onChange", (Component)this, (Object)value));
    }

    public boolean isShowHiddenFolders() {
        return this.showHiddenFolders;
    }

    public void setShowHiddenFolders(boolean showHiddenFolders) {
        this.showHiddenFolders = showHiddenFolders;
    }
}

