/*
 * Decompiled with CFR 0.152.
 */
package tools.dynamia.modules.entityfile.ui.components;

import org.zkoss.zk.ui.event.Event;
import org.zkoss.zk.ui.event.EventListener;
import org.zkoss.zul.Treeitem;
import org.zkoss.zul.TreeitemRenderer;
import tools.dynamia.io.FileInfo;
import tools.dynamia.modules.entityfile.ui.components.DirectoryTreeNode;
import tools.dynamia.ui.icons.IconSize;
import tools.dynamia.ui.icons.IconsTheme;

public class DirectoryTreeItemRenderer
implements TreeitemRenderer<DirectoryTreeNode>,
EventListener<Event> {
    public void render(Treeitem item, DirectoryTreeNode data, int index) {
        item.setValue((Object)data);
        item.setLabel(((FileInfo)data.getData()).getName());
        item.addEventListener("onOpen", (EventListener)this);
        item.addEventListener("onClose", (EventListener)this);
        this.setupIcon(item);
    }

    public void onEvent(Event event) {
        Treeitem item = (Treeitem)event.getTarget();
        DirectoryTreeNode node = (DirectoryTreeNode)((Object)item.getValue());
        if (item.isOpen()) {
            node.load();
        } else {
            node.getChildren().clear();
        }
        this.setupIcon(item);
    }

    private void setupIcon(Treeitem item) {
        DirectoryTreeNode node = (DirectoryTreeNode)((Object)item.getValue());
        if (item.isOpen()) {
            item.setImage(IconsTheme.get().getIcon("folder-open").getRealPath(IconSize.SMALL));
        } else {
            item.setImage(IconsTheme.get().getIcon("folder").getRealPath(IconSize.SMALL));
        }
        if (!((FileInfo)node.getData()).getFile().canRead() || !((FileInfo)node.getData()).getFile().canWrite()) {
            if (item.isOpen()) {
                item.setImage(IconsTheme.get().getIcon("folder-red-open").getRealPath(IconSize.SMALL));
            } else {
                item.setImage(IconsTheme.get().getIcon("folder-red").getRealPath(IconSize.SMALL));
            }
        }
    }
}

