/*
 * Decompiled with CFR 0.152.
 */
package tools.dynamia.modules.entityfile.ui.components;

import org.zkoss.util.media.AMedia;
import org.zkoss.util.media.Media;
import org.zkoss.zul.Filedownload;
import org.zkoss.zul.Toolbarbutton;
import tools.dynamia.modules.entityfile.StoredEntityFile;
import tools.dynamia.modules.entityfile.domain.EntityFile;
import tools.dynamia.modules.entityfile.ui.util.EntityFileUtils;
import tools.dynamia.zk.BindingComponentIndex;
import tools.dynamia.zk.ComponentAliasIndex;

public class EntityFileDownloadlink
extends Toolbarbutton {
    private static final long serialVersionUID = -2182747459195865750L;
    private EntityFile entityFile;
    private boolean showLabel = true;

    public EntityFileDownloadlink() {
        this.setIconSclass("z-icon-paperclip");
        this.addEventListener("onClick", event -> {
            if (this.entityFile != null) {
                StoredEntityFile sef = this.entityFile.getStoredEntityFile();
                if (sef.getRealFile() != null && sef.getRealFile().exists()) {
                    AMedia media = new AMedia(this.entityFile.getName(), this.entityFile.getExtension(), null, sef.getRealFile(), null);
                    Filedownload.save((Media)media, (String)this.entityFile.getName());
                } else {
                    EntityFileUtils.showDownloadDialog(this.entityFile.getStoredEntityFile());
                }
            }
        });
    }

    public EntityFile getValue() {
        return this.entityFile;
    }

    public void setValue(EntityFile entityFile) {
        this.entityFile = entityFile;
        this.rendererLabel();
    }

    private void rendererLabel() {
        if (this.showLabel) {
            this.setLabel(this.entityFile.getName());
        }
        this.setTooltiptext(this.entityFile.getName());
    }

    public boolean isShowLabel() {
        return this.showLabel;
    }

    public void setShowLabel(boolean showLabel) {
        this.showLabel = showLabel;
    }

    static {
        BindingComponentIndex.getInstance().put("value", EntityFileDownloadlink.class);
        ComponentAliasIndex.getInstance().put("entityfileDownloadlink", EntityFileDownloadlink.class);
    }
}

