/*
 * Decompiled with CFR 0.152.
 */
package tools.dynamia.modules.entityfile.ui.components;

import org.zkoss.image.AImage;
import org.zkoss.image.Image;
import org.zkoss.zk.ui.Component;
import tools.dynamia.commons.SimpleCache;
import tools.dynamia.io.IOUtils;
import tools.dynamia.io.Resource;
import tools.dynamia.modules.entityfile.StoredEntityFile;
import tools.dynamia.modules.entityfile.domain.EntityFile;
import tools.dynamia.zk.BindingComponentIndex;
import tools.dynamia.zk.ComponentAliasIndex;
import tools.dynamia.zk.ImageCache;

public class EntityFileImage
extends org.zkoss.zul.Image {
    private static SimpleCache<Long, String> URL_CACHE = new SimpleCache();
    private static SimpleCache<Long, String> URL_THUMB_CACHE = new SimpleCache();
    private static final long serialVersionUID = -2182747459195865750L;
    private EntityFile entityFile;
    private boolean thumbnail = false;
    private int thumbnailHeight = 64;
    private int thumbnailWidth = 64;
    private String noPhotoPath = "/zkau/web/tools/images/no-photo.jpg";

    public EntityFile getValue() {
        return this.entityFile;
    }

    public void setValue(EntityFile entityFile) {
        this.entityFile = entityFile;
        this.loadImage();
    }

    private void loadImage() {
        block7: {
            if (this.entityFile != null) {
                Long key = this.entityFile.getId();
                try {
                    StoredEntityFile sef = this.entityFile.getStoredEntityFile();
                    if (this.isThumbnail()) {
                        String thumbUrl = (String)URL_THUMB_CACHE.getOrLoad((Object)key, k -> this.entityFile.getStoredEntityFile().getThumbnailUrl(this.thumbnailWidth, this.thumbnailHeight));
                        this.setSrc(thumbUrl);
                        break block7;
                    }
                    this.setSrc((String)URL_CACHE.getOrLoad((Object)key, k -> this.entityFile.toURL()));
                }
                catch (Exception e) {
                    e.printStackTrace();
                    this.loadNoPhoto();
                }
            } else {
                this.loadNoPhoto();
            }
        }
        if (this.isThumbnail()) {
            this.setStyle("max-height: " + this.thumbnailHeight + "px; max-width: " + this.thumbnailWidth + "px");
        } else {
            this.setStyle(null);
        }
    }

    private void loadNoPhoto() {
        try {
            if (this.noPhotoPath != null) {
                if (this.noPhotoPath.startsWith("classpath")) {
                    Resource resource;
                    AImage imageContent = ImageCache.get((String)this.noPhotoPath);
                    if (imageContent == null && (resource = IOUtils.getResource((String)this.noPhotoPath)).exists()) {
                        imageContent = new AImage(resource.getFilename(), resource.getInputStream());
                        ImageCache.add((String)this.noPhotoPath, (AImage)imageContent);
                    }
                    if (imageContent != null) {
                        this.setContent((Image)imageContent);
                    }
                } else {
                    this.setSrc(this.noPhotoPath);
                }
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public boolean isThumbnail() {
        return this.thumbnail;
    }

    public void setThumbnail(boolean thumbnail) {
        this.thumbnail = thumbnail;
    }

    public int getThumbnailHeight() {
        return this.thumbnailHeight;
    }

    public void setThumbnailHeight(int thumbnailHeight) {
        this.thumbnailHeight = thumbnailHeight;
    }

    public int getThumbnailWidth() {
        return this.thumbnailWidth;
    }

    public void setThumbnailWidth(int thumbnailWidth) {
        this.thumbnailWidth = thumbnailWidth;
    }

    public String getNoPhotoPath() {
        return this.noPhotoPath;
    }

    public void setNoPhotoPath(String noPhotoPath) {
        this.noPhotoPath = noPhotoPath;
    }

    public void setParent(Component parent) {
        super.setParent(parent);
        this.loadImage();
    }

    public static void clearCache() {
        URL_CACHE.clear();
        URL_THUMB_CACHE.clear();
    }

    public static void clearCache(EntityFile file) {
        if (file != null && file.getId() != null) {
            URL_CACHE.remove((Object)file.getId());
            URL_THUMB_CACHE.remove((Object)file.getId());
        }
    }

    static {
        BindingComponentIndex.getInstance().put("value", EntityFileImage.class);
        ComponentAliasIndex.getInstance().put("entityfileImage", EntityFileImage.class);
    }
}

