/*
 * Decompiled with CFR 0.152.
 */
package tools.dynamia.modules.entityfile.ui.components;

import java.io.File;
import tools.dynamia.commons.Messages;
import tools.dynamia.integration.Containers;
import tools.dynamia.io.FileInfo;
import tools.dynamia.modules.entityfile.EntityFileException;
import tools.dynamia.modules.entityfile.UploadedFileInfo;
import tools.dynamia.modules.entityfile.domain.EntityFile;
import tools.dynamia.modules.entityfile.service.EntityFileService;
import tools.dynamia.zk.BindingComponentIndex;
import tools.dynamia.zk.ComponentAliasIndex;
import tools.dynamia.zk.ui.Uploadlink;

public class EntityFileUploadlink
extends Uploadlink {
    private static final long serialVersionUID = -2182747459195865750L;
    private EntityFile entityFile;
    private EntityFileService service = (EntityFileService)Containers.get().findObject(EntityFileService.class);
    private boolean shared;
    private String subfolder;
    private String storedFileName;

    public EntityFile getValue() {
        if (this.entityFile == null && this.getUploadedFile() != null) {
            this.onFileUpload();
        }
        return this.entityFile;
    }

    public void setValue(EntityFile entityFile) {
        this.entityFile = entityFile;
        if (entityFile != null) {
            this.configureFileInfo();
        } else {
            this.setUploadedFile(null);
            this.setLabel(Messages.get(Uploadlink.class, (String)"upload"));
        }
    }

    private void configureFileInfo() {
        this.setUploadedFile(new FileInfo(new File("")));
        this.setLabel(this.entityFile.getName());
        this.setClientDataAttribute("uuid", this.entityFile.getUuid());
    }

    protected void onFileUpload() {
        try {
            UploadedFileInfo uploadedFileInfo = new UploadedFileInfo(this.getUploadedFile());
            uploadedFileInfo.setShared(this.isShared());
            uploadedFileInfo.setSubfolder(this.getSubfolder());
            if (this.storedFileName != null && !this.storedFileName.isEmpty()) {
                if (this.storedFileName.equals("real")) {
                    uploadedFileInfo.setStoredFileName(this.getUploadedFile().getName());
                } else {
                    uploadedFileInfo.setStoredFileName(this.storedFileName);
                }
            }
            this.entityFile = this.service.createTemporalEntityFile(uploadedFileInfo);
            this.setLabel(this.entityFile.getName());
        }
        catch (Exception e) {
            throw new EntityFileException((Throwable)e);
        }
    }

    public boolean isShared() {
        return this.shared;
    }

    public void setShared(boolean shared) {
        this.shared = shared;
    }

    public String getSubfolder() {
        return this.subfolder;
    }

    public void setSubfolder(String subfolder) {
        this.subfolder = subfolder;
    }

    public String getStoredFileName() {
        return this.storedFileName;
    }

    public void setStoredFileName(String storedFileName) {
        this.storedFileName = storedFileName;
    }

    static {
        BindingComponentIndex.getInstance().put("value", EntityFileUploadlink.class);
        ComponentAliasIndex.getInstance().put("entityfileUploadlink", EntityFileUploadlink.class);
    }
}

