/*
 * Decompiled with CFR 0.152.
 */
package tools.dynamia.modules.entityfile.ui.components;

import java.util.Collection;
import java.util.Optional;
import org.zkoss.zul.Combobox;
import org.zkoss.zul.ListModelList;
import tools.dynamia.integration.Containers;
import tools.dynamia.modules.entityfile.EntityFileStorage;
import tools.dynamia.zk.BindingComponentIndex;
import tools.dynamia.zk.ComponentAliasIndex;
import tools.dynamia.zk.util.ZKUtil;

public class StorageCombobox
extends Combobox {
    private static final long serialVersionUID = 3507817129731334840L;
    private String selected;

    public StorageCombobox() {
        this.setReadonly(true);
        this.setItemRenderer((item, data, index) -> {
            EntityFileStorage storage = (EntityFileStorage)data;
            item.setValue((Object)storage.getId());
            item.setLabel(storage.getName());
        });
        ZKUtil.fillCombobox((Combobox)this, (Collection)Containers.get().findObjects(EntityFileStorage.class), (boolean)true);
    }

    public String getSelected() {
        this.selected = null;
        if (this.getSelectedItem() != null) {
            this.selected = (String)this.getSelectedItem().getValue();
        }
        return this.selected;
    }

    public void setSelected(String selected) {
        if (selected != this.selected) {
            this.selected = selected;
            try {
                Optional<EntityFileStorage> selectedStorage = Containers.get().findObjects(EntityFileStorage.class).stream().filter(efs -> efs.getId().equals(selected)).findFirst();
                if (selectedStorage.isPresent()) {
                    ListModelList model = (ListModelList)this.getModel();
                    model.addToSelection((Object)selectedStorage.get());
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    static {
        ComponentAliasIndex.getInstance().put("storagebox", StorageCombobox.class);
        BindingComponentIndex.getInstance().put("selected", StorageCombobox.class);
    }
}

