/*
 * Decompiled with CFR 0.152.
 */
package top.codewood.wx.mnp.api;

import com.google.gson.JsonObject;
import top.codewood.wx.common.api.WxBaseHttpApi;
import top.codewood.wx.common.bean.WxAccessToken;
import top.codewood.wx.mnp.bean.result.WxMnpCode2SessionResult;
import top.codewood.wx.mnp.util.json.WxGsonBuilder;

public class WxMnpApi
extends WxBaseHttpApi {
    public static WxMnpApi getInstance() {
        return Holder.INSTANCE;
    }

    public WxMnpCode2SessionResult code2Session(String appid, String secret, String jscode) {
        assert (appid != null && secret != null && jscode != null);
        String url = String.format("https://api.weixin.qq.com/sns/jscode2session?appid=%s&secret=%s&js_code=%s&grant_type=authorization_code", appid, secret, jscode);
        String respStr = WxMnpApi.get((String)url);
        return (WxMnpCode2SessionResult)WxGsonBuilder.instance().fromJson(respStr, WxMnpCode2SessionResult.class);
    }

    public WxAccessToken getAccessToken(String appid, String secret) {
        assert (appid != null && secret != null);
        String url = String.format("https://api.weixin.qq.com/cgi-bin/token?grant_type=client_credential&appid=%s&secret=%s", appid, secret);
        String respStr = WxMnpApi.get((String)url);
        return (WxAccessToken)WxGsonBuilder.instance().fromJson(respStr, WxAccessToken.class);
    }

    public String getPaidUnionId(String accessToken, String openid, String transactionId) {
        assert (accessToken != null && openid != null && transactionId != null);
        String url = String.format("https://api.weixin.qq.com/wxa/getpaidunionid?access_token=%s&openid=%s&transaction_id=%s", accessToken, openid, transactionId);
        String respStr = WxMnpApi.get((String)url);
        JsonObject json = WxGsonBuilder.instance().toJsonTree((Object)respStr).getAsJsonObject();
        return json.get("unionid").getAsString();
    }

    public String getPaidUnionId(String accessToken, String openid, String mchid, String outTradeNo) {
        assert (accessToken != null && openid != null && mchid != null && outTradeNo != null);
        String url = String.format("https://api.weixin.qq.com/wxa/getpaidunionid?access_token=%s&openid=%s&mch_id=%s&out_trade_no=%s", accessToken, openid, mchid, outTradeNo);
        String respStr = WxMnpApi.get((String)url);
        JsonObject json = WxGsonBuilder.instance().toJsonTree((Object)respStr).getAsJsonObject();
        return json.get("unionid").getAsString();
    }

    private static class Holder {
        private static final WxMnpApi INSTANCE = new WxMnpApi();

        private Holder() {
        }
    }
}

