/*
 * Decompiled with CFR 0.152.
 */
package top.codewood.wx.mnp.bean.analysis;

import com.google.gson.annotations.SerializedName;
import java.io.Serializable;
import java.time.LocalDate;
import java.time.ZoneOffset;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;

public class WxMnpPerformanceRequest
implements Serializable {
    private Time time;
    private String module;
    private List<Param> params;

    public Time getTime() {
        return this.time;
    }

    public void setTime(Time time) {
        this.time = time;
    }

    public String getModule() {
        return this.module;
    }

    public void setModule(String module) {
        this.module = module;
    }

    public List<Param> getParams() {
        return this.params;
    }

    public void setParams(List<Param> params) {
        this.params = params;
    }

    public void addParam(String field, String value) {
        if (this.params == null) {
            this.params = new ArrayList<Param>();
        }
        this.params.add(new Param(field, value));
    }

    public String toString() {
        return "PreformanceRequest{time=" + this.time + ", module='" + this.module + '\'' + ", params=" + this.params + '}';
    }

    public static class Param {
        private String field;
        private String value;

        public Param() {
        }

        public Param(String field, String value) {
            this.field = field;
            this.value = value;
        }

        public String getField() {
            return this.field;
        }

        public void setField(String field) {
            this.field = field;
        }

        public String getValue() {
            return this.value;
        }

        public void setValue(String value) {
            this.value = value;
        }

        public String toString() {
            return "Param{field='" + this.field + '\'' + ", value='" + this.value + '\'' + '}';
        }
    }

    public static interface Module {
        public static final String M_10016 = "10016";
        public static final String M_10017 = "10017";
        public static final String M_10021 = "10021";
        public static final String M_10022 = "10022";
        public static final String M_10023 = "10023";
    }

    public static class Time {
        @SerializedName(value="begin_timestamp")
        private long beginTimeStamp;
        @SerializedName(value="end_timestamp")
        private long endTimeStamp;

        public Time() {
        }

        public Time(Date beginDate, Date endDate) {
            this.beginTimeStamp = beginDate.getTime() / 1000L;
            this.endTimeStamp = endDate.getTime() / 1000L;
        }

        public Time(LocalDate beginDate, LocalDate endDate) {
            this.beginTimeStamp = beginDate.atStartOfDay(ZoneOffset.ofHours(8)).toEpochSecond();
            this.endTimeStamp = endDate.atStartOfDay(ZoneOffset.ofHours(8)).toEpochSecond();
        }

        public long getBeginTimeStamp() {
            return this.beginTimeStamp;
        }

        public void setBeginTimeStamp(long beginTimeStamp) {
            this.beginTimeStamp = beginTimeStamp;
        }

        public long getEndTimeStamp() {
            return this.endTimeStamp;
        }

        public void setEndTimeStamp(long endTimeStamp) {
            this.endTimeStamp = endTimeStamp;
        }

        public String toString() {
            return "Time{beginTimeStamp=" + this.beginTimeStamp + ", endTimeStamp=" + this.endTimeStamp + '}';
        }
    }
}

