/*
 * Decompiled with CFR 0.152.
 */
package top.codewood.wx.mnp.api;

import com.google.gson.Gson;
import com.google.gson.JsonObject;
import java.time.LocalDate;
import java.time.format.DateTimeFormatter;
import java.util.ArrayList;
import java.util.List;
import top.codewood.wx.common.api.WxBaseHttpApi;
import top.codewood.wx.mnp.bean.analysis.WxMnpPerformanceRequest;
import top.codewood.wx.mnp.bean.analysis.WxMnpPerformanceResult;
import top.codewood.wx.mnp.bean.analysis.WxMnpRetainInfo;
import top.codewood.wx.mnp.bean.analysis.WxMnpSummaryTrend;
import top.codewood.wx.mnp.bean.analysis.WxMnpUserPortrait;
import top.codewood.wx.mnp.bean.analysis.WxMnpVisitDistribution;
import top.codewood.wx.mnp.bean.analysis.WxMnpVisitPage;
import top.codewood.wx.mnp.bean.analysis.WxMnpVisitTrend;
import top.codewood.wx.mnp.util.json.WxGsonBuilder;

public class WxMnpAnalysisApi
extends WxBaseHttpApi {
    public static WxMnpAnalysisApi getInstance() {
        return Holder.INSTANCE;
    }

    public WxMnpRetainInfo getDailyRetainInfo(String accessToken, LocalDate date) {
        assert (accessToken != null && date != null);
        String url = String.format("https://api.weixin.qq.com/datacube/getweanalysisappiddailyretaininfo?access_token=%s", accessToken);
        return this.getRetainInfo(url, date, date);
    }

    public WxMnpRetainInfo getMonthlyRetainInfo(String accessToken, LocalDate beginDate, LocalDate endDate) {
        assert (accessToken != null && beginDate != null && endDate != null);
        String url = String.format("https://api.weixin.qq.com/datacube/getweanalysisappidmonthlyretaininfo?access_token=%s", accessToken);
        return this.getRetainInfo(url, beginDate, endDate);
    }

    public WxMnpRetainInfo getWeeklyRetainInfo(String accessToken, LocalDate beginDate, LocalDate endDate) {
        assert (accessToken != null && beginDate != null && endDate != null);
        String url = String.format("https://api.weixin.qq.com/datacube/getweanalysisappidweeklyretaininfo?access_token=%s", accessToken);
        return this.getRetainInfo(url, beginDate, endDate);
    }

    public List<WxMnpSummaryTrend> getSummaryThrend(String accessToken, LocalDate beginDate, LocalDate endDate) {
        assert (accessToken != null && beginDate != null && endDate != null);
        String url = String.format("https://api.weixin.qq.com/datacube/getweanalysisappiddailysummarytrend?access_token=%s", accessToken);
        return this.getAnalysisResultAsList(url, beginDate, endDate, WxMnpSummaryTrend.class);
    }

    public List<WxMnpVisitTrend> getDailyVisitTrend(String accessToken, LocalDate date) {
        assert (accessToken != null && date != null);
        String url = String.format("https://api.weixin.qq.com/datacube/getweanalysisappiddailyvisittrend?access_token=%s", accessToken);
        return this.getAnalysisResultAsList(url, date, date, WxMnpVisitTrend.class);
    }

    public List<WxMnpVisitTrend> getMonthlyVisitTrend(String accessToken, LocalDate beginDate, LocalDate endDate) {
        assert (accessToken != null && beginDate != null && endDate != null);
        String url = String.format("https://api.weixin.qq.com/datacube/getweanalysisappidmonthlyvisittrend?access_token=%s", accessToken);
        return this.getAnalysisResultAsList(url, beginDate, endDate, WxMnpVisitTrend.class);
    }

    public List<WxMnpVisitTrend> getWeeklyVisitTrend(String accessToken, LocalDate beginDate, LocalDate endDate) {
        assert (accessToken != null && beginDate != null && endDate != null);
        String url = String.format("https://api.weixin.qq.com/datacube/getweanalysisappidweeklyvisittrend?access_token=%s", accessToken);
        return this.getAnalysisResultAsList(url, beginDate, endDate, WxMnpVisitTrend.class);
    }

    public WxMnpPerformanceResult getPerformanceData(String accessToken, WxMnpPerformanceRequest performanceRequest) {
        assert (accessToken != null && performanceRequest != null);
        String url = String.format("https://api.weixin.qq.com/wxa/business/performance/boot?access_token=%s", accessToken);
        Gson gson = WxGsonBuilder.instance();
        String postData = gson.toJson((Object)performanceRequest);
        String respStr = WxMnpAnalysisApi.post((String)url, (String)postData);
        return (WxMnpPerformanceResult)gson.fromJson(respStr, WxMnpPerformanceResult.class);
    }

    public WxMnpUserPortrait getUserPortrait(String accessToken, LocalDate beginDate, LocalDate endDate) {
        assert (accessToken != null && beginDate != null && endDate != null);
        String url = String.format("https://api.weixin.qq.com/datacube/getweanalysisappiduserportrait?access_token=%s", accessToken);
        return this.getAnalysisData(url, beginDate, endDate, WxMnpUserPortrait.class);
    }

    public WxMnpVisitDistribution getVisitDistribution(String accessToken, LocalDate date) {
        assert (accessToken != null && date != null);
        String url = String.format("https://api.weixin.qq.com/datacube/getweanalysisappidvisitdistribution?access_token=%s", accessToken);
        return this.getAnalysisData(url, date, date, WxMnpVisitDistribution.class);
    }

    public WxMnpVisitPage getVisitPage(String accessToken, LocalDate beginDate, LocalDate endDate) {
        assert (accessToken != null && beginDate != null && endDate != null);
        String url = String.format("https://api.weixin.qq.com/datacube/getweanalysisappidvisitpage?access_token=%s", accessToken);
        return this.getAnalysisData(url, beginDate, endDate, WxMnpVisitPage.class);
    }

    private WxMnpRetainInfo getRetainInfo(String url, LocalDate beginDate, LocalDate endDate) {
        return this.getAnalysisData(url, beginDate, endDate, WxMnpRetainInfo.class);
    }

    private <T> T getAnalysisData(String url, LocalDate beginDate, LocalDate endDate, Class<T> clz) {
        String respStr = WxMnpAnalysisApi.post((String)url, (String)this.dateToJson(beginDate, endDate).toString());
        return (T)WxGsonBuilder.instance().fromJson(respStr, clz);
    }

    private <T> List<T> getAnalysisResultAsList(String url, LocalDate beginDate, LocalDate endDate, Class<T> clz) {
        String respStr = WxMnpAnalysisApi.post((String)url, (String)this.dateToJson(beginDate, endDate).toString());
        Gson gson = WxGsonBuilder.instance();
        JsonObject jsonObject = (JsonObject)gson.fromJson(respStr, JsonObject.class);
        if (jsonObject.has("list")) {
            ArrayList list = new ArrayList();
            jsonObject.get("list").getAsJsonArray().forEach(jsonEle -> list.add(gson.fromJson(jsonEle, clz)));
            return list;
        }
        return null;
    }

    private JsonObject dateToJson(LocalDate beginDate, LocalDate endDate) {
        JsonObject json = new JsonObject();
        json.addProperty("begin_date", DateTimeFormatter.ofPattern("yyyyMMdd").format(beginDate));
        json.addProperty("end_date", DateTimeFormatter.ofPattern("yyyyMMdd").format(endDate));
        return json;
    }

    private static class Holder {
        private static final WxMnpAnalysisApi INSTANCE = new WxMnpAnalysisApi();

        private Holder() {
        }
    }
}

