/*
 * Decompiled with CFR 0.152.
 */
package top.codewood.wx.mnp.api;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.util.UUID;
import top.codewood.wx.common.api.WxBaseHttpApi;
import top.codewood.wx.common.bean.media.WxMediaUploadResult;
import top.codewood.wx.common.util.file.FileUtils;
import top.codewood.wx.mnp.util.json.WxGsonBuilder;

public class WxMnpMediaApi
extends WxBaseHttpApi {
    public static WxMnpMediaApi getInstance() {
        return Holder.INSTANCE;
    }

    public WxMediaUploadResult uploadTempMedia(String accessToken, File file) {
        assert (accessToken != null && file != null);
        String url = String.format("https://api.weixin.qq.com/cgi-bin/media/upload?access_token=%s&type=image", accessToken);
        String respStr = WxMnpMediaApi.upload((String)url, (File)file);
        return (WxMediaUploadResult)WxGsonBuilder.instance().fromJson(respStr, WxMediaUploadResult.class);
    }

    public WxMediaUploadResult uploadTempMedia(String accessToken, InputStream inputStream) throws IOException {
        assert (accessToken != null && inputStream != null);
        File tmpFile = FileUtils.createTmpFile((InputStream)inputStream, (String)UUID.randomUUID().toString(), (String)"jpg");
        return this.uploadTempMedia(accessToken, tmpFile);
    }

    public InputStream getTempMedia(String accessToken, String mediaId) {
        assert (accessToken != null && mediaId != null);
        String url = String.format("https://api.weixin.qq.com/cgi-bin/media/get?access_token=%s&media_id=%s", accessToken, mediaId);
        return WxMnpMediaApi.getInputStream((String)url);
    }

    private static class Holder {
        private static final WxMnpMediaApi INSTANCE = new WxMnpMediaApi();

        private Holder() {
        }
    }
}

