/*
 * Decompiled with CFR 0.152.
 */
package top.codewood.wx.mnp.api;

import com.google.gson.JsonObject;
import java.io.InputStream;
import java.util.Map;
import top.codewood.wx.common.api.WxBaseHttpApi;
import top.codewood.wx.mnp.util.json.WxGsonBuilder;

public class WxMnpQrcodeApi
extends WxBaseHttpApi {
    public static WxMnpQrcodeApi getInstance() {
        return Holder.INSTANCE;
    }

    public InputStream createQrcode(String accessToken, String path, Integer width) {
        assert (accessToken != null && path != null);
        String url = String.format("https://api.weixin.qq.com/cgi-bin/wxaapp/createwxaqrcode?access_token=%s", accessToken);
        JsonObject json = new JsonObject();
        json.addProperty("path", path);
        if (width != null) {
            json.addProperty("width", (Number)width);
        }
        return WxMnpQrcodeApi.postInputStream((String)url, (String)json.toString());
    }

    public InputStream get(String accessToken, String path, Integer width, Boolean autoColor, Map<String, Integer> lineColor, Boolean isHyaline) {
        assert (accessToken != null && path != null);
        String url = String.format("https://api.weixin.qq.com/wxa/getwxacode?access_token=%s", accessToken);
        JsonObject json = new JsonObject();
        json.addProperty("path", path);
        if (width != null) {
            json.addProperty("width", (Number)width);
        }
        if (autoColor != null) {
            json.addProperty("auto_color", autoColor);
        }
        if (lineColor != null) {
            json.addProperty("line_color", WxGsonBuilder.instance().toJson(lineColor));
        }
        if (isHyaline != null) {
            json.addProperty("is_hyaline", isHyaline);
        }
        return WxMnpQrcodeApi.postInputStream((String)url, (String)json.toString());
    }

    public InputStream get(String accessToken, String path) {
        return this.get(accessToken, path, null, null, null, null);
    }

    public InputStream getUnlimited(String accessToken, String scene, String page, Integer width, Boolean autoColor, Map<String, Integer> lineColor, Boolean isHyaline) {
        assert (accessToken != null && scene != null);
        String url = String.format("https://api.weixin.qq.com/wxa/getwxacodeunlimit?access_token=%s", accessToken);
        JsonObject json = new JsonObject();
        json.addProperty("scene", scene);
        if (page != null) {
            json.addProperty("page", page);
        }
        if (width != null) {
            json.addProperty("width", (Number)width);
        }
        if (autoColor != null) {
            json.addProperty("auto_color", autoColor);
        }
        if (lineColor != null) {
            json.addProperty("line_color", WxGsonBuilder.instance().toJson(lineColor));
        }
        if (isHyaline != null) {
            json.addProperty("is_hyaline", isHyaline);
        }
        return WxMnpQrcodeApi.postInputStream((String)url, (String)json.toString());
    }

    public InputStream getUnlimited(String accessToken, String scene, String page) {
        return this.getUnlimited(accessToken, scene, page, null, null, null, null);
    }

    public InputStream getUnlimited(String accessToken, String scene) {
        return this.getUnlimited(accessToken, scene, null, null, null, null, null);
    }

    private static class Holder {
        private static final WxMnpQrcodeApi INSTANCE = new WxMnpQrcodeApi();

        private Holder() {
        }
    }
}

