/*
 * Decompiled with CFR 0.152.
 */
package top.codewood.wx.mnp.api;

import com.google.gson.JsonObject;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.util.UUID;
import top.codewood.wx.common.api.WxBaseHttpApi;
import top.codewood.wx.common.util.file.FileUtils;
import top.codewood.wx.mnp.bean.search.WxMnpImgSearchResult;
import top.codewood.wx.mnp.bean.search.WxMnpSearchSubmitPage;
import top.codewood.wx.mnp.bean.search.WxMnpSiteSearchResult;
import top.codewood.wx.mnp.util.json.WxGsonBuilder;

public class WxMnpSearchApi
extends WxBaseHttpApi {
    private static String UPLOAD_FILE_NAME = "img";

    public static WxMnpSearchApi getInstance() {
        return Holder.INSTANCE;
    }

    public WxMnpImgSearchResult imgSearch(String accessToken, File file) {
        assert (accessToken != null && file != null);
        String url = String.format("https://api.weixin.qq.com/wxa/imagesearch?access_token=%s", accessToken);
        String respStr = WxMnpSearchApi.upload((String)url, (File)file, (String)UPLOAD_FILE_NAME);
        return (WxMnpImgSearchResult)WxGsonBuilder.instance().fromJson(respStr, WxMnpImgSearchResult.class);
    }

    public WxMnpImgSearchResult imgSearch(String accessToken, InputStream inputStream) throws IOException {
        assert (accessToken != null && inputStream != null);
        String url = String.format("https://api.weixin.qq.com/wxa/imagesearch?access_token=%s", accessToken);
        File tmpFile = FileUtils.createTmpFile((InputStream)inputStream, (String)UUID.randomUUID().toString(), (String)"jpg");
        String respStr = WxMnpSearchApi.upload((String)url, (File)tmpFile, (String)UPLOAD_FILE_NAME);
        return (WxMnpImgSearchResult)WxGsonBuilder.instance().fromJson(respStr, WxMnpImgSearchResult.class);
    }

    public WxMnpSiteSearchResult siteSearch(String accessToken, String keyword, String nextPageInfo) {
        assert (accessToken != null && keyword != null);
        String url = String.format("https://api.weixin.qq.com/wxa/sitesearch?access_token=%s", accessToken);
        JsonObject paramJson = new JsonObject();
        paramJson.addProperty("keyword", keyword);
        paramJson.addProperty("next_page_info", nextPageInfo == null ? "" : nextPageInfo);
        String respStr = WxMnpSearchApi.post((String)url, (String)paramJson.toString());
        return (WxMnpSiteSearchResult)WxGsonBuilder.instance().fromJson(respStr, WxMnpSiteSearchResult.class);
    }

    public void submitPages(String accessToken, WxMnpSearchSubmitPage ... pages) {
        assert (accessToken != null && pages != null && pages.length > 0);
        String url = String.format("https://api.weixin.qq.com/wxa/search/wxaapi_submitpages?access_token=%s", accessToken);
        WxMnpSearchApi.post((String)url, (String)WxGsonBuilder.instance().toJson((Object)pages));
    }

    private static class Holder {
        private static final WxMnpSearchApi INSTANCE = new WxMnpSearchApi();

        private Holder() {
        }
    }
}

