/*
 * Decompiled with CFR 0.152.
 */
package top.codewood.wx.mnp.api;

import com.google.gson.JsonObject;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.UnsupportedEncodingException;
import java.net.URLEncoder;
import java.nio.charset.StandardCharsets;
import java.util.UUID;
import top.codewood.wx.common.api.WxBaseHttpApi;
import top.codewood.wx.common.util.file.FileUtils;
import top.codewood.wx.mnp.bean.ocr.BusinessLincense;
import top.codewood.wx.mnp.bean.ocr.DriverLicense;
import top.codewood.wx.mnp.bean.ocr.IdCard;
import top.codewood.wx.mnp.bean.ocr.PrintedTextOcrResult;
import top.codewood.wx.mnp.bean.ocr.VehicleLicense;
import top.codewood.wx.mnp.util.json.WxGsonBuilder;

public class WxMnpOcrApi
extends WxBaseHttpApi {
    private static String UPLOAD_FILE_NAME = "img";

    public static WxMnpOcrApi getInstance() {
        return Holder.INSTANCE;
    }

    public String bankcard(String accessToken, File img) {
        assert (accessToken != null && img != null);
        String url = String.format("https://api.weixin.qq.com/cv/ocr/bankcard?access_token=%s", accessToken);
        String respStr = WxMnpOcrApi.upload((String)url, (File)img, (String)UPLOAD_FILE_NAME);
        return ((JsonObject)WxGsonBuilder.instance().fromJson(respStr, JsonObject.class)).get("number").getAsString();
    }

    public String bankcard(String accessToken, InputStream inputStream) throws IOException {
        assert (accessToken != null && inputStream != null);
        String url = String.format("https://api.weixin.qq.com/cv/ocr/bankcard?access_token=%s", accessToken);
        File tmpFile = FileUtils.createTmpFile((InputStream)inputStream, (String)UUID.randomUUID().toString(), (String)"jpg");
        String respStr = WxMnpOcrApi.upload((String)url, (File)tmpFile, (String)UPLOAD_FILE_NAME);
        return ((JsonObject)WxGsonBuilder.instance().fromJson(respStr, JsonObject.class)).get("number").getAsString();
    }

    public String bankcard(String accessToken, String imgUrl) {
        assert (accessToken != null && imgUrl != null);
        String encodedUrl = null;
        try {
            encodedUrl = URLEncoder.encode(imgUrl, StandardCharsets.UTF_8.name());
        }
        catch (UnsupportedEncodingException e) {
            encodedUrl = imgUrl;
        }
        String url = String.format("https://api.weixin.qq.com/cv/ocr/bankcard?img_url=%s&access_token=%s", encodedUrl, accessToken);
        String respStr = WxMnpOcrApi.get((String)url);
        return ((JsonObject)WxGsonBuilder.instance().fromJson(respStr, JsonObject.class)).get("number").getAsString();
    }

    public BusinessLincense businessLicense(String accessToke, File file) {
        assert (accessToke != null && file != null);
        String url = String.format("https://api.weixin.qq.com/cv/ocr/bizlicense?access_token=%s", accessToke);
        String respStr = WxMnpOcrApi.upload((String)url, (File)file, (String)UPLOAD_FILE_NAME);
        return (BusinessLincense)WxGsonBuilder.instance().fromJson(respStr, BusinessLincense.class);
    }

    public BusinessLincense businessLicense(String accessToke, InputStream inputStream) throws IOException {
        assert (accessToke != null && inputStream != null);
        String url = String.format("https://api.weixin.qq.com/cv/ocr/bizlicense?access_token=%s", accessToke);
        File tmpFile = FileUtils.createTmpFile((InputStream)inputStream, (String)UUID.randomUUID().toString(), (String)"jpg");
        String respStr = WxMnpOcrApi.upload((String)url, (File)tmpFile, (String)UPLOAD_FILE_NAME);
        return (BusinessLincense)WxGsonBuilder.instance().fromJson(respStr, BusinessLincense.class);
    }

    public BusinessLincense businessLicense(String accessToke, String imgUrl) throws IOException {
        assert (accessToke != null && imgUrl != null);
        String encodedUrl = null;
        try {
            encodedUrl = URLEncoder.encode(imgUrl, StandardCharsets.UTF_8.name());
        }
        catch (UnsupportedEncodingException e) {
            encodedUrl = imgUrl;
        }
        String url = String.format("https://api.weixin.qq.com/cv/ocr/bizlicense?img_url=%s&access_token=%s", encodedUrl, accessToke);
        String respStr = WxMnpOcrApi.get((String)url);
        return (BusinessLincense)WxGsonBuilder.instance().fromJson(respStr, BusinessLincense.class);
    }

    public DriverLicense driverLicense(String accessToken, String imgUrl) {
        assert (accessToken != null && imgUrl != null);
        String encodedUrl = null;
        try {
            encodedUrl = URLEncoder.encode(imgUrl, StandardCharsets.UTF_8.name());
        }
        catch (UnsupportedEncodingException e) {
            encodedUrl = imgUrl;
        }
        String url = String.format("https://api.weixin.qq.com/cv/ocr/drivinglicense?img_url=%s&access_token=%s", encodedUrl, accessToken);
        String respStr = WxMnpOcrApi.get((String)url);
        return (DriverLicense)WxGsonBuilder.instance().fromJson(respStr, DriverLicense.class);
    }

    public DriverLicense driverLicense(String accessToken, File file) {
        assert (accessToken != null && file != null);
        String url = String.format("https://api.weixin.qq.com/cv/ocr/idcard?access_token=%s", accessToken);
        String respStr = WxMnpOcrApi.upload((String)url, (File)file, (String)UPLOAD_FILE_NAME);
        return (DriverLicense)WxGsonBuilder.instance().fromJson(respStr, DriverLicense.class);
    }

    public DriverLicense driverLicense(String accessToken, InputStream inputStream) throws IOException {
        assert (accessToken != null && inputStream != null);
        String url = String.format("https://api.weixin.qq.com/cv/ocr/idcard?access_token=%s", accessToken);
        File tmpFile = FileUtils.createTmpFile((InputStream)inputStream, (String)UUID.randomUUID().toString(), (String)"jpg");
        String respStr = WxMnpOcrApi.upload((String)url, (File)tmpFile, (String)UPLOAD_FILE_NAME);
        return (DriverLicense)WxGsonBuilder.instance().fromJson(respStr, DriverLicense.class);
    }

    public PrintedTextOcrResult printedText(String accessToken, String imgUrl) {
        assert (accessToken != null && imgUrl != null);
        String encodedUrl = null;
        try {
            encodedUrl = URLEncoder.encode(imgUrl, StandardCharsets.UTF_8.name());
        }
        catch (UnsupportedEncodingException e) {
            encodedUrl = imgUrl;
        }
        String url = String.format("https://api.weixin.qq.com/cv/ocr/comm?img_url=%s&access_token=%s", encodedUrl, accessToken);
        String respStr = WxMnpOcrApi.get((String)url);
        return (PrintedTextOcrResult)WxGsonBuilder.instance().fromJson(respStr, PrintedTextOcrResult.class);
    }

    public PrintedTextOcrResult printedText(String accessToken, File file) {
        assert (accessToken != null && file != null);
        String url = String.format("https://api.weixin.qq.com/cv/ocr/comm?access_token=%s", accessToken);
        String respStr = WxMnpOcrApi.upload((String)url, (File)file, (String)UPLOAD_FILE_NAME);
        return (PrintedTextOcrResult)WxGsonBuilder.instance().fromJson(respStr, PrintedTextOcrResult.class);
    }

    public PrintedTextOcrResult printedText(String accessToken, InputStream inputStream) throws IOException {
        assert (accessToken != null && inputStream != null);
        String url = String.format("https://api.weixin.qq.com/cv/ocr/comm?access_token=%s", accessToken);
        File tmpFile = FileUtils.createTmpFile((InputStream)inputStream, (String)UUID.randomUUID().toString(), (String)"jpg");
        String respStr = WxMnpOcrApi.upload((String)url, (File)tmpFile, (String)UPLOAD_FILE_NAME);
        return (PrintedTextOcrResult)WxGsonBuilder.instance().fromJson(respStr, PrintedTextOcrResult.class);
    }

    public IdCard idCard(String accessToken, String imgUrl) {
        assert (accessToken != null && imgUrl != null);
        String encodedUrl = null;
        try {
            encodedUrl = URLEncoder.encode(imgUrl, StandardCharsets.UTF_8.name());
        }
        catch (UnsupportedEncodingException e) {
            encodedUrl = imgUrl;
        }
        String url = String.format("https://api.weixin.qq.com/cv/ocr/idcard?img_url=%s&access_token=%s", encodedUrl, accessToken);
        String respStr = WxMnpOcrApi.get((String)url);
        return (IdCard)WxGsonBuilder.instance().fromJson(respStr, IdCard.class);
    }

    public IdCard idCard(String accessToken, File file) {
        assert (accessToken != null && file != null);
        String url = String.format("https://api.weixin.qq.com/cv/ocr/idcard?access_token=%s", accessToken);
        String respStr = WxMnpOcrApi.upload((String)url, (File)file, (String)UPLOAD_FILE_NAME);
        return (IdCard)WxGsonBuilder.instance().fromJson(respStr, IdCard.class);
    }

    public IdCard idCard(String accessToken, InputStream inputStream) throws IOException {
        assert (accessToken != null && inputStream != null);
        String url = String.format("https://api.weixin.qq.com/cv/ocr/idcard?access_token=%s", accessToken);
        File tmpFile = FileUtils.createTmpFile((InputStream)inputStream, (String)UUID.randomUUID().toString(), (String)"jpg");
        String respStr = WxMnpOcrApi.upload((String)url, (File)tmpFile, (String)UPLOAD_FILE_NAME);
        return (IdCard)WxGsonBuilder.instance().fromJson(respStr, IdCard.class);
    }

    public VehicleLicense vehicleLicense(String accessToken, String imgUrl) {
        assert (accessToken != null && imgUrl != null);
        String encodedUrl = null;
        try {
            encodedUrl = URLEncoder.encode(imgUrl, StandardCharsets.UTF_8.name());
        }
        catch (UnsupportedEncodingException e) {
            encodedUrl = imgUrl;
        }
        String url = String.format("https://api.weixin.qq.com/cv/ocr/driving?img_url=%s&access_token=%s", encodedUrl, accessToken);
        String respStr = WxMnpOcrApi.get((String)url);
        return (VehicleLicense)WxGsonBuilder.instance().fromJson(respStr, VehicleLicense.class);
    }

    public VehicleLicense vehicleLicense(String accessToken, File file) {
        assert (accessToken != null && file != null);
        String url = String.format("https://api.weixin.qq.com/cv/ocr/driving?img_url=%s&access_token=%s", accessToken);
        String respStr = WxMnpOcrApi.upload((String)url, (File)file, (String)UPLOAD_FILE_NAME);
        return (VehicleLicense)WxGsonBuilder.instance().fromJson(respStr, VehicleLicense.class);
    }

    public VehicleLicense vehicleLicense(String accessToken, InputStream inputStream) throws IOException {
        assert (accessToken != null && inputStream != null);
        String url = String.format("https://api.weixin.qq.com/cv/ocr/driving?access_token=%s", accessToken);
        File tmpFile = FileUtils.createTmpFile((InputStream)inputStream, (String)UUID.randomUUID().toString(), (String)"jpg");
        String respStr = WxMnpOcrApi.upload((String)url, (File)tmpFile, (String)UPLOAD_FILE_NAME);
        return (VehicleLicense)WxGsonBuilder.instance().fromJson(respStr, VehicleLicense.class);
    }

    private static class Holder {
        private static final WxMnpOcrApi INSTANCE = new WxMnpOcrApi();

        private Holder() {
        }
    }
}

