/*
 * Decompiled with CFR 0.152.
 */
package top.codewood.wx.mnp.api;

import com.google.gson.Gson;
import com.google.gson.JsonObject;
import java.util.ArrayList;
import java.util.List;
import org.apache.http.message.BasicNameValuePair;
import top.codewood.wx.common.api.WxBaseHttpApi;
import top.codewood.wx.mnp.bean.subscribemsg.WxMnpPubTemplateKeyword;
import top.codewood.wx.mnp.bean.subscribemsg.WxMnpPubTemplateTitleList;
import top.codewood.wx.mnp.bean.subscribemsg.WxMnpSubscribeMsg;
import top.codewood.wx.mnp.bean.subscribemsg.WxMnpTemplateCategory;
import top.codewood.wx.mnp.bean.subscribemsg.WxMnpTemplateInfo;
import top.codewood.wx.mnp.util.json.WxGsonBuilder;

public class WxMnpSubscribeApi
extends WxBaseHttpApi {
    public static WxMnpSubscribeApi getInstance() {
        return Holder.INSTANCE;
    }

    public String addTemplate(String accessToken, String tid, List<Integer> kidList, String sceneDesc) {
        assert (accessToken != null && kidList != null);
        if (kidList.size() > 5 || kidList.size() < 2) {
            throw new RuntimeException("kidList: \u6700\u591a\u652f\u63015\u4e2a\uff0c\u6700\u5c112\u4e2a\u5173\u952e\u8bcd\u7ec4\u5408");
        }
        String url = String.format("https://api.weixin.qq.com/wxaapi/newtmpl/addtemplate?access_token=%s", accessToken);
        ArrayList<BasicNameValuePair> parameters = new ArrayList<BasicNameValuePair>();
        parameters.add(new BasicNameValuePair("tid", tid));
        for (int i = 0; i < kidList.size(); ++i) {
            parameters.add(new BasicNameValuePair(String.format("kidList[%s]", i), String.valueOf(kidList.get(i))));
        }
        if (sceneDesc != null && sceneDesc.trim() != "") {
            parameters.add(new BasicNameValuePair("sceneDesc", sceneDesc));
        }
        String respStr = WxMnpSubscribeApi.post((String)url, parameters);
        JsonObject retJson = (JsonObject)WxGsonBuilder.instance().fromJson(respStr, JsonObject.class);
        return retJson.get("priTmplId").getAsString();
    }

    public void deleteTemplate(String accessToken, String priTmplId) {
        assert (accessToken != null && priTmplId != null);
        String url = String.format("https://api.weixin.qq.com/wxaapi/newtmpl/deltemplate?access_token=%s", accessToken);
        ArrayList<BasicNameValuePair> parameters = new ArrayList<BasicNameValuePair>();
        parameters.add(new BasicNameValuePair("priTmplId", priTmplId));
        WxMnpSubscribeApi.post((String)url, parameters);
    }

    public List<WxMnpTemplateInfo> getTemplateList(String accessToken) {
        assert (accessToken != null);
        String url = String.format("https://api.weixin.qq.com/wxaapi/newtmpl/gettemplate?access_token=%s", accessToken);
        return this.getDataResultAsList(url, WxMnpTemplateInfo.class);
    }

    public List<WxMnpTemplateCategory> getCategory(String accessToken) {
        assert (accessToken != null);
        String url = String.format("https://api.weixin.qq.com/wxaapi/newtmpl/getcategory?access_token=%s", accessToken);
        return this.getDataResultAsList(url, WxMnpTemplateCategory.class);
    }

    public WxMnpPubTemplateTitleList getPubTemplateTitleList(String accessToken, String[] ids, int start, int limit) {
        assert (accessToken != null && ids != null);
        String url = String.format("https://api.weixin.qq.com/wxaapi/newtmpl/getpubtemplatetitles?access_token=%s&ids=%s&start=%s&limit=%s", accessToken, String.join((CharSequence)",", ids), start, limit);
        String respStr = WxMnpSubscribeApi.get((String)url);
        return (WxMnpPubTemplateTitleList)WxGsonBuilder.instance().fromJson(respStr, WxMnpPubTemplateTitleList.class);
    }

    public WxMnpPubTemplateTitleList getPubTemplateTitleList(String accessToken, String[] ids) {
        return this.getPubTemplateTitleList(accessToken, ids, 0, 30);
    }

    public List<WxMnpPubTemplateKeyword> getPubTemplateKeyWordsById(String accessToken, String tid) {
        assert (accessToken != null && tid != null);
        String url = String.format("https://api.weixin.qq.com/wxaapi/newtmpl/getpubtemplatekeywords?access_token=%s&tid=%s", accessToken, tid);
        return this.getDataResultAsList(url, WxMnpPubTemplateKeyword.class);
    }

    public void send(String accessToken, WxMnpSubscribeMsg subscribeMsg) {
        assert (accessToken != null && subscribeMsg != null);
        String url = String.format("https://api.weixin.qq.com/cgi-bin/message/subscribe/send?access_token=%s", accessToken);
        WxMnpSubscribeApi.post((String)url, (String)WxGsonBuilder.instance().toJson((Object)subscribeMsg));
    }

    private <T> List<T> getDataResultAsList(String url, Class<T> clz) {
        String respStr = WxMnpSubscribeApi.get((String)url);
        Gson gson = WxGsonBuilder.instance();
        JsonObject jsonObject = (JsonObject)gson.fromJson(respStr, JsonObject.class);
        if (jsonObject.has("data")) {
            ArrayList list = new ArrayList();
            jsonObject.get("data").getAsJsonArray().forEach(jsonEle -> list.add(gson.fromJson(jsonEle, clz)));
            return list;
        }
        return null;
    }

    private static class Holder {
        private static final WxMnpSubscribeApi INSTANCE = new WxMnpSubscribeApi();

        private Holder() {
        }
    }
}

