/*
 * Decompiled with CFR 0.152.
 */
package top.codewood.wx.mnp.api;

import org.apache.commons.codec.digest.DigestUtils;
import top.codewood.util.http.WxHttpClient;
import top.codewood.wx.mnp.bean.user.WxMnpPhoneInfo;
import top.codewood.wx.mnp.bean.user.WxMnpUserInfo;
import top.codewood.wx.mnp.util.crypt.WxMnpCryptUtils;
import top.codewood.wx.mnp.util.json.WxGsonBuilder;

public class WxMnpUserApi
extends WxHttpClient {
    public static WxMnpUserApi getInstance() {
        return Holder.INSTANCE;
    }

    public boolean checkUserInfo(String sessionKey, String rawData, String signature) {
        String generatedSignature = DigestUtils.sha1Hex((String)(rawData + sessionKey));
        return generatedSignature.equals(signature);
    }

    public WxMnpUserInfo getUserInfo(String sessionKey, String encryptedData, String iv) {
        String decryptedData = WxMnpCryptUtils.decrypt(sessionKey, encryptedData, iv);
        return (WxMnpUserInfo)WxGsonBuilder.instance().fromJson(decryptedData, WxMnpUserInfo.class);
    }

    public WxMnpPhoneInfo getPhoneInfo(String sessionKey, String encryptedData, String iv) {
        String decryptedData = WxMnpCryptUtils.decrypt(sessionKey, encryptedData, iv);
        return (WxMnpPhoneInfo)WxGsonBuilder.instance().fromJson(decryptedData, WxMnpPhoneInfo.class);
    }

    private static class Holder {
        private static final WxMnpUserApi INSTANCE = new WxMnpUserApi();

        private Holder() {
        }
    }
}

