/*
 * Decompiled with CFR 0.152.
 */
package top.jfunc.json.impl;

import com.alibaba.fastjson.JSON;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import top.jfunc.json.Json;
import top.jfunc.json.JsonArray;
import top.jfunc.json.JsonObject;
import top.jfunc.json.impl.BaseJson;
import top.jfunc.json.impl.JSONObject;

public class JSONArray
extends BaseJson<JSONArray>
implements JsonArray {
    private com.alibaba.fastjson.JSONArray jsonArray;

    public JSONArray(com.alibaba.fastjson.JSONArray jsonArray) {
        this.jsonArray = jsonArray;
    }

    public JSONArray(List<Object> list) {
        this.jsonArray = new com.alibaba.fastjson.JSONArray(list);
    }

    public JSONArray() {
        this.jsonArray = new com.alibaba.fastjson.JSONArray();
    }

    public JSONArray(String arrayString) {
        this.jsonArray = JSON.parseArray((String)arrayString);
    }

    @Override
    public int size() {
        return this.jsonArray.size();
    }

    @Override
    public Object get(int index) {
        this.assertIndex(index, this.size());
        return this.checkNullValue(index, this.jsonArray.get(index));
    }

    @Override
    public String getString(int index) {
        this.assertIndex(index, this.size());
        return this.checkNullValue(index, this.jsonArray.getString(index));
    }

    @Override
    public Boolean getBoolean(int index) {
        this.assertIndex(index, this.size());
        return this.checkNullValue(index, this.jsonArray.getBoolean(index));
    }

    @Override
    public Integer getInteger(int index) {
        this.assertIndex(index, this.size());
        return this.checkNullValue(index, this.jsonArray.getInteger(index));
    }

    @Override
    public Long getLong(int index) {
        this.assertIndex(index, this.size());
        return this.checkNullValue(index, this.jsonArray.getLong(index));
    }

    @Override
    public Double getDouble(int index) {
        this.assertIndex(index, this.size());
        return this.checkNullValue(index, this.jsonArray.getDouble(index));
    }

    @Override
    public Float getFloat(int index) {
        this.assertIndex(index, this.size());
        return this.checkNullValue(index, this.jsonArray.getFloat(index));
    }

    @Override
    public BigInteger getBigInteger(int index) {
        this.assertIndex(index, this.size());
        return this.checkNullValue(index, this.jsonArray.getBigInteger(index));
    }

    @Override
    public BigDecimal getBigDecimal(int index) {
        this.assertIndex(index, this.size());
        return this.checkNullValue(index, this.jsonArray.getBigDecimal(index));
    }

    @Override
    public JsonObject getJsonObject(int index) {
        this.assertIndex(index, this.size());
        Object opt = this.jsonArray.get(index);
        if (opt instanceof com.alibaba.fastjson.JSONObject) {
            return new JSONObject((com.alibaba.fastjson.JSONObject)opt);
        }
        if (opt instanceof Map) {
            return new JSONObject((Map)opt);
        }
        return (JsonObject)opt;
    }

    @Override
    public JsonArray getJsonArray(int index) {
        this.assertIndex(index, this.size());
        Object opt = this.jsonArray.get(index);
        if (opt instanceof com.alibaba.fastjson.JSONArray) {
            return new JSONArray((com.alibaba.fastjson.JSONArray)opt);
        }
        if (opt instanceof List) {
            return new JSONArray((List)opt);
        }
        return (JsonArray)opt;
    }

    @Override
    public JsonArray remove(int index) {
        this.jsonArray.remove(index);
        return this;
    }

    @Override
    public JsonArray clear() {
        this.jsonArray.clear();
        return this;
    }

    @Override
    public JsonArray put(Object o) {
        this.jsonArray.add(o);
        return this;
    }

    @Override
    public JsonArray put(int index, Object o) {
        this.jsonArray.remove(index);
        this.jsonArray.add(index, o);
        return this;
    }

    @Override
    public JsonArray putAll(Collection<?> os) {
        this.jsonArray.addAll(os);
        return this;
    }

    @Override
    public JsonArray parse(String jsonString) {
        this.jsonArray = JSON.parseArray((String)jsonString);
        return this;
    }

    public com.alibaba.fastjson.JSONArray unwrap() {
        return this.jsonArray;
    }

    @Override
    public String toString() {
        HashMap<Integer, Json> map = new HashMap<Integer, Json>();
        int size = this.size();
        for (int i = 0; i < size; ++i) {
            Object o = this.jsonArray.get(i);
            if (!(o instanceof JsonObject) && !(o instanceof JsonArray)) continue;
            map.put(i, (Json)o);
        }
        map.forEach((k, v) -> {
            this.jsonArray.remove(k.intValue());
            this.jsonArray.add(k.intValue(), v.unwrap());
        });
        return this.jsonArray.toString();
    }

    @Override
    public int hashCode() {
        return this.jsonArray.hashCode();
    }

    @Override
    public boolean equals(Object obj) {
        return this.jsonArray.equals(obj);
    }

    @Override
    public JsonArray fromList(List<Object> list) {
        this.jsonArray = new com.alibaba.fastjson.JSONArray(list);
        return this;
    }
}

