/*
 * Decompiled with CFR 0.152.
 */
package top.jfunc.json.impl;

import com.alibaba.fastjson.JSON;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import top.jfunc.json.Json;
import top.jfunc.json.JsonArray;
import top.jfunc.json.JsonObject;
import top.jfunc.json.impl.BaseJson;
import top.jfunc.json.impl.JSONArray;

public class JSONObject
extends BaseJson<JSONObject>
implements JsonObject {
    private com.alibaba.fastjson.JSONObject jsonObject;

    public JSONObject(com.alibaba.fastjson.JSONObject jsonObject) {
        this.jsonObject = jsonObject;
    }

    public JSONObject(Map<String, Object> map) {
        this.jsonObject = new com.alibaba.fastjson.JSONObject(map);
    }

    public JSONObject() {
        this.jsonObject = new com.alibaba.fastjson.JSONObject();
    }

    public JSONObject(String jsonString) {
        this.jsonObject = JSON.parseObject((String)jsonString);
    }

    public com.alibaba.fastjson.JSONObject unwrap() {
        return this.jsonObject;
    }

    public Object get(String key) {
        this.assertKey(key);
        return this.checkNullValue(key, this.jsonObject.get((Object)key));
    }

    public Object get(String key, Object defaultObject) {
        this.assertKey(key);
        Object temp = this.jsonObject.get((Object)key);
        return null == temp ? defaultObject : temp;
    }

    public JsonObject getJsonObject(String key) {
        this.assertKey(key);
        Object temp = this.jsonObject.get((Object)key);
        Object t = this.checkNullValue(key, temp);
        if (t instanceof com.alibaba.fastjson.JSONObject) {
            return new JSONObject((com.alibaba.fastjson.JSONObject)t);
        }
        if (t instanceof Map) {
            return new JSONObject((Map)t);
        }
        return (JsonObject)t;
    }

    public JsonArray getJsonArray(String key) {
        this.assertKey(key);
        Object temp = this.jsonObject.get((Object)key);
        Object t = this.checkNullValue(key, temp);
        if (t instanceof com.alibaba.fastjson.JSONArray) {
            return new JSONArray((com.alibaba.fastjson.JSONArray)t);
        }
        if (t instanceof List) {
            return new JSONArray((List)t);
        }
        return (JsonArray)t;
    }

    public String getString(String key) {
        this.assertKey(key);
        String temp = this.jsonObject.getString(key);
        return (String)this.checkNullValue(key, temp);
    }

    public String getString(String key, String defaultValue) {
        this.assertKey(key);
        String temp = this.jsonObject.getString(key);
        return null == temp ? defaultValue : temp;
    }

    public Boolean getBoolean(String key) {
        this.assertKey(key);
        Boolean temp = this.jsonObject.getBoolean(key);
        return (Boolean)this.checkNullValue(key, temp);
    }

    public Boolean getBoolean(String key, Boolean defaultValue) {
        this.assertKey(key);
        Boolean temp = this.jsonObject.getBoolean(key);
        return null == temp ? defaultValue : temp;
    }

    public Integer getInteger(String key) {
        this.assertKey(key);
        Integer temp = this.jsonObject.getInteger(key);
        return (Integer)this.checkNullValue(key, temp);
    }

    public Integer getInteger(String key, Integer defaultValue) {
        this.assertKey(key);
        Integer temp = this.jsonObject.getInteger(key);
        return null == temp ? defaultValue : temp;
    }

    public Long getLong(String key) {
        this.assertKey(key);
        Long temp = this.jsonObject.getLong(key);
        return (Long)this.checkNullValue(key, temp);
    }

    public Long getLong(String key, Long defaultValue) {
        this.assertKey(key);
        Long temp = this.jsonObject.getLong(key);
        return null == temp ? defaultValue : temp;
    }

    public Float getFloat(String key) {
        this.assertKey(key);
        Float temp = this.jsonObject.getFloat(key);
        return (Float)this.checkNullValue(key, temp);
    }

    public Float getFloat(String key, Float defaultValue) {
        this.assertKey(key);
        Float temp = this.jsonObject.getFloat(key);
        return null == temp ? defaultValue : temp;
    }

    public Double getDouble(String key) {
        this.assertKey(key);
        Double temp = this.jsonObject.getDouble(key);
        return (Double)this.checkNullValue(key, temp);
    }

    public Double getDouble(String key, Double defaultValue) {
        this.assertKey(key);
        Double temp = this.jsonObject.getDouble(key);
        return null == temp ? defaultValue : temp;
    }

    public BigInteger getBigInteger(String key) {
        this.assertKey(key);
        BigInteger temp = this.jsonObject.getBigInteger(key);
        return (BigInteger)this.checkNullValue(key, temp);
    }

    public BigInteger getBigInteger(String key, BigInteger defaultValue) {
        this.assertKey(key);
        BigInteger temp = this.jsonObject.getBigInteger(key);
        return null == temp ? defaultValue : temp;
    }

    public BigDecimal getBigDecimal(String key) {
        this.assertKey(key);
        BigDecimal temp = this.jsonObject.getBigDecimal(key);
        return (BigDecimal)this.checkNullValue(key, temp);
    }

    public BigDecimal getBigDecimal(String key, BigDecimal defaultValue) {
        this.assertKey(key);
        BigDecimal temp = this.jsonObject.getBigDecimal(key);
        return null == temp ? defaultValue : temp;
    }

    public <T> T get(String key, Class<T> clazz) {
        return (T)this.jsonObject.getObject(key, clazz);
    }

    public Set<String> keySet() {
        return this.jsonObject.keySet();
    }

    public int size() {
        return this.jsonObject.size();
    }

    public boolean isEmpty() {
        return this.jsonObject.isEmpty();
    }

    public boolean containsKey(String key) {
        return this.jsonObject.containsKey((Object)key);
    }

    public boolean containsValue(Object value) {
        return this.jsonObject.containsValue(value);
    }

    public JsonObject put(String key, Object value) {
        this.jsonObject.put(key, value);
        return this;
    }

    public JsonObject putAll(Map<? extends String, ?> m) {
        this.jsonObject.putAll(m);
        return this;
    }

    public JsonObject clear() {
        this.jsonObject.clear();
        return this;
    }

    public Object remove(String key) {
        return this.jsonObject.remove((Object)key);
    }

    public JsonObject parse(String jsonString) {
        this.jsonObject = JSON.parseObject((String)jsonString);
        return this;
    }

    public JsonObject fromMap(Map<String, Object> map) {
        return new JSONObject(new com.alibaba.fastjson.JSONObject(map));
    }

    public String serialize(Object javaBean) {
        return JSON.toJSONString((Object)javaBean);
    }

    public <T> T deserialize(String jsonString, Class<T> clazz) {
        return (T)JSON.parseObject((String)jsonString, clazz);
    }

    public String toString() {
        HashMap<String, Json> map = new HashMap<String, Json>();
        for (String key : this.jsonObject.keySet()) {
            Object o = this.jsonObject.get((Object)key);
            if (!(o instanceof JsonObject) && !(o instanceof JsonArray)) continue;
            map.put(key, (Json)o);
        }
        map.forEach((k, v) -> this.jsonObject.put(k, v.unwrap()));
        return this.jsonObject.toString();
    }

    public int hashCode() {
        return this.jsonObject.hashCode();
    }

    public boolean equals(Object obj) {
        return this.jsonObject.equals(obj);
    }
}

