/*
 * Decompiled with CFR 0.152.
 */
package top.jfunc.json.impl;

import java.math.BigDecimal;
import java.math.BigInteger;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import top.jfunc.json.Json;
import top.jfunc.json.JsonArray;
import top.jfunc.json.JsonException;
import top.jfunc.json.JsonObject;
import top.jfunc.json.impl.BaseJson;
import top.jfunc.json.impl.JSONArray;
import top.jfunc.json.impl.ValueCompatible;

public class JSONObject
extends BaseJson<JSONObject>
implements JsonObject {
    private org.json.JSONObject jsonObject;

    public JSONObject(org.json.JSONObject jsonObject) {
        this.jsonObject = jsonObject;
    }

    public JSONObject(Map<String, Object> map) {
        this.jsonObject = new org.json.JSONObject(map);
    }

    public JSONObject() {
        this.jsonObject = new org.json.JSONObject();
    }

    public JSONObject(String jsonString) {
        this.jsonObject = new org.json.JSONObject(jsonString);
    }

    public org.json.JSONObject unwrap() {
        return this.jsonObject;
    }

    public Object get(String key) {
        this.assertKey(key);
        return this.checkNullValue(key, this.jsonObject.opt(key));
    }

    public Object get(String key, Object defaultObject) {
        this.assertKey(key);
        Object temp = this.jsonObject.opt(key);
        return null == temp ? defaultObject : temp;
    }

    public JsonObject getJsonObject(String key) {
        this.assertKey(key);
        Object temp = this.jsonObject.opt(key);
        Object t = this.checkNullValue(key, temp);
        if (t instanceof org.json.JSONObject) {
            return new JSONObject((org.json.JSONObject)t);
        }
        if (t instanceof Map) {
            return new JSONObject((Map)t);
        }
        return (JsonObject)t;
    }

    public JsonArray getJsonArray(String key) {
        this.assertKey(key);
        Object temp = this.jsonObject.opt(key);
        Object t = this.checkNullValue(key, temp);
        if (t instanceof org.json.JSONArray) {
            return new JSONArray((org.json.JSONArray)t);
        }
        if (t instanceof List) {
            return new JSONArray((List)t);
        }
        return (JsonArray)t;
    }

    public String getString(String key) {
        return this.getString(key, null);
    }

    public String getString(String key, String defaultValue) {
        this.assertKey(key);
        boolean has = this.jsonObject.has(key);
        if (!has) {
            return (String)this.checkNullValue(key, defaultValue);
        }
        String temp = this.isTolerant() ? (String)ValueCompatible.compatibleValue((Object)this.jsonObject.get(key), String.class) : this.jsonObject.getString(key);
        return temp;
    }

    public Boolean getBoolean(String key) {
        return this.getBoolean(key, null);
    }

    public Boolean getBoolean(String key, Boolean defaultValue) {
        this.assertKey(key);
        boolean has = this.jsonObject.has(key);
        if (!has) {
            return (Boolean)this.checkNullValue(key, defaultValue);
        }
        Boolean temp = this.isTolerant() ? (Boolean)ValueCompatible.compatibleValue((Object)this.jsonObject.get(key), Boolean.class) : Boolean.valueOf(this.jsonObject.getBoolean(key));
        return temp;
    }

    public Integer getInteger(String key) {
        return this.getInteger(key, null);
    }

    public Integer getInteger(String key, Integer defaultValue) {
        this.assertKey(key);
        boolean has = this.jsonObject.has(key);
        if (!has) {
            return (Integer)this.checkNullValue(key, defaultValue);
        }
        Integer temp = this.isTolerant() ? (Integer)ValueCompatible.compatibleValue((Object)this.jsonObject.get(key), Integer.class) : Integer.valueOf(this.jsonObject.getInt(key));
        return temp;
    }

    public Long getLong(String key) {
        return this.getLong(key, null);
    }

    public Long getLong(String key, Long defaultValue) {
        this.assertKey(key);
        boolean has = this.jsonObject.has(key);
        if (!has) {
            return (Long)this.checkNullValue(key, defaultValue);
        }
        Long temp = this.isTolerant() ? (Long)ValueCompatible.compatibleValue((Object)this.jsonObject.get(key), Long.class) : Long.valueOf(this.jsonObject.getLong(key));
        return temp;
    }

    public Float getFloat(String key) {
        return this.getFloat(key, null);
    }

    public Float getFloat(String key, Float defaultValue) {
        this.assertKey(key);
        boolean has = this.jsonObject.has(key);
        if (!has) {
            return (Float)this.checkNullValue(key, defaultValue);
        }
        Float temp = this.isTolerant() ? (Float)ValueCompatible.compatibleValue((Object)this.jsonObject.get(key), Float.class) : Float.valueOf(this.jsonObject.getFloat(key));
        return temp;
    }

    public Double getDouble(String key) {
        return this.getDouble(key, null);
    }

    public Double getDouble(String key, Double defaultValue) {
        this.assertKey(key);
        boolean has = this.jsonObject.has(key);
        if (!has) {
            return (Double)this.checkNullValue(key, defaultValue);
        }
        Double temp = this.isTolerant() ? (Double)ValueCompatible.compatibleValue((Object)this.jsonObject.get(key), Double.class) : Double.valueOf(this.jsonObject.getDouble(key));
        return temp;
    }

    public BigInteger getBigInteger(String key) {
        return this.getBigInteger(key, null);
    }

    public BigInteger getBigInteger(String key, BigInteger defaultValue) {
        this.assertKey(key);
        boolean has = this.jsonObject.has(key);
        if (!has) {
            return (BigInteger)this.checkNullValue(key, defaultValue);
        }
        BigInteger temp = this.isTolerant() ? (BigInteger)ValueCompatible.compatibleValue((Object)this.jsonObject.get(key), BigInteger.class) : this.jsonObject.getBigInteger(key);
        return temp;
    }

    public BigDecimal getBigDecimal(String key) {
        return this.getBigDecimal(key, null);
    }

    public BigDecimal getBigDecimal(String key, BigDecimal defaultValue) {
        this.assertKey(key);
        boolean has = this.jsonObject.has(key);
        if (!has) {
            return (BigDecimal)this.checkNullValue(key, defaultValue);
        }
        BigDecimal temp = this.isTolerant() ? (BigDecimal)ValueCompatible.compatibleValue((Object)this.jsonObject.get(key), BigDecimal.class) : this.jsonObject.getBigDecimal(key);
        return temp;
    }

    public <T> T get(String key, Class<T> clazz) {
        this.assertKey(key);
        boolean has = this.jsonObject.has(key);
        if (!has) {
            return (T)this.checkNullValue(key, null);
        }
        Object temp = ValueCompatible.compatibleValue((Object)this.jsonObject.get(key), clazz);
        return (T)this.checkNullValue(key, temp);
    }

    public Set<String> keySet() {
        return this.jsonObject.keySet();
    }

    public int size() {
        return this.jsonObject.length();
    }

    public boolean isEmpty() {
        return this.jsonObject.length() == 0;
    }

    public boolean containsKey(String key) {
        return this.jsonObject.has(key);
    }

    public boolean containsValue(Object value) {
        Set keySet = this.jsonObject.keySet();
        for (String key : keySet) {
            Object o = this.jsonObject.get(key);
            if (null == o || !o.equals(value)) continue;
            return true;
        }
        return false;
    }

    public JsonObject put(String key, Object value) {
        this.jsonObject.put(key, value);
        return this;
    }

    public JsonObject putAll(Map<? extends String, ?> m) {
        m.forEach((arg_0, arg_1) -> ((org.json.JSONObject)this.jsonObject).put(arg_0, arg_1));
        return this;
    }

    public JsonObject clear() {
        Set keySet = this.jsonObject.keySet();
        for (Object key : keySet.toArray()) {
            this.jsonObject.remove(key.toString());
        }
        return this;
    }

    public Object remove(String key) {
        return this.jsonObject.remove(key);
    }

    public JsonObject parse(String jsonString) {
        this.jsonObject = new org.json.JSONObject(jsonString);
        return this;
    }

    public JsonObject fromMap(Map<String, Object> map) {
        this.jsonObject = new org.json.JSONObject(map);
        return new JSONObject(map);
    }

    public String serialize(Object javaBean) {
        throw new JsonException((Exception)new UnsupportedOperationException());
    }

    public <T> T deserialize(String jsonString, Class<T> clazz) {
        throw new JsonException((Exception)new UnsupportedOperationException());
    }

    public String toString() {
        HashMap<String, Json> map = new HashMap<String, Json>();
        for (String key : this.jsonObject.keySet()) {
            Object o = this.jsonObject.get(key);
            if (!(o instanceof JsonObject) && !(o instanceof JsonArray)) continue;
            map.put(key, (Json)o);
        }
        map.forEach((k, v) -> this.jsonObject.put(k, v.unwrap()));
        return this.jsonObject.toString();
    }

    public int hashCode() {
        return this.jsonObject.hashCode();
    }

    public boolean equals(Object obj) {
        return this.jsonObject.equals(obj);
    }
}

