/*
 * Decompiled with CFR 0.152.
 */
package top.jfunc.json.impl;

import java.math.BigDecimal;
import java.math.BigInteger;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import top.jfunc.json.Json;
import top.jfunc.json.JsonArray;
import top.jfunc.json.JsonObject;
import top.jfunc.json.impl.BaseJson;
import top.jfunc.json.impl.JSONObject;
import top.jfunc.json.impl.ValueCompatible;

public class JSONArray
extends BaseJson<JSONArray>
implements JsonArray {
    private org.json.JSONArray jsonArray;

    public JSONArray(org.json.JSONArray jsonArray) {
        this.jsonArray = jsonArray;
    }

    public JSONArray(List<Object> list) {
        this.jsonArray = new org.json.JSONArray(list);
    }

    public JSONArray() {
        this.jsonArray = new org.json.JSONArray();
    }

    public JSONArray(String arrayString) {
        this.jsonArray = new org.json.JSONArray(arrayString);
    }

    public org.json.JSONArray unwrap() {
        return this.jsonArray;
    }

    public JsonArray parse(String arrayString) {
        this.jsonArray = new org.json.JSONArray(arrayString);
        return this;
    }

    public int size() {
        return this.jsonArray.length();
    }

    public Object get(int index) {
        this.assertIndex(index, this.size());
        Object opt = this.jsonArray.opt(index);
        return this.checkNullValue(index, opt);
    }

    public String getString(int index) {
        this.assertIndex(index, this.size());
        String temp = this.isTolerant() ? (String)ValueCompatible.compatibleValue((Object)this.jsonArray.opt(index), String.class) : this.jsonArray.getString(index);
        return (String)this.checkNullValue(index, temp);
    }

    public Boolean getBoolean(int index) {
        this.assertIndex(index, this.size());
        Boolean temp = this.isTolerant() ? (Boolean)ValueCompatible.compatibleValue((Object)this.jsonArray.opt(index), Boolean.class) : Boolean.valueOf(this.jsonArray.getBoolean(index));
        return (Boolean)this.checkNullValue(index, temp);
    }

    public Integer getInteger(int index) {
        this.assertIndex(index, this.size());
        Integer temp = this.isTolerant() ? (Integer)ValueCompatible.compatibleValue((Object)this.jsonArray.opt(index), Integer.class) : Integer.valueOf(this.jsonArray.getInt(index));
        return (Integer)this.checkNullValue(index, temp);
    }

    public Long getLong(int index) {
        this.assertIndex(index, this.size());
        Long temp = this.isTolerant() ? (Long)ValueCompatible.compatibleValue((Object)this.jsonArray.opt(index), Long.class) : Long.valueOf(this.jsonArray.getLong(index));
        return (Long)this.checkNullValue(index, temp);
    }

    public Double getDouble(int index) {
        this.assertIndex(index, this.size());
        Double temp = this.isTolerant() ? (Double)ValueCompatible.compatibleValue((Object)this.jsonArray.opt(index), Double.class) : Double.valueOf(this.jsonArray.getDouble(index));
        return (Double)this.checkNullValue(index, temp);
    }

    public Float getFloat(int index) {
        this.assertIndex(index, this.size());
        Float temp = this.isTolerant() ? (Float)ValueCompatible.compatibleValue((Object)this.jsonArray.opt(index), Float.class) : Float.valueOf(this.jsonArray.getFloat(index));
        return (Float)this.checkNullValue(index, temp);
    }

    public BigInteger getBigInteger(int index) {
        this.assertIndex(index, this.size());
        BigInteger temp = this.isTolerant() ? (BigInteger)ValueCompatible.compatibleValue((Object)this.jsonArray.opt(index), BigInteger.class) : this.jsonArray.getBigInteger(index);
        return (BigInteger)this.checkNullValue(index, temp);
    }

    public BigDecimal getBigDecimal(int index) {
        this.assertIndex(index, this.size());
        BigDecimal temp = this.isTolerant() ? (BigDecimal)ValueCompatible.compatibleValue((Object)this.jsonArray.opt(index), BigDecimal.class) : this.jsonArray.getBigDecimal(index);
        return (BigDecimal)this.checkNullValue(index, temp);
    }

    public JsonObject getJsonObject(int index) {
        this.assertIndex(index, this.size());
        Object opt = this.jsonArray.opt(index);
        if (opt instanceof org.json.JSONObject) {
            return new JSONObject((org.json.JSONObject)opt);
        }
        if (opt instanceof Map) {
            return new JSONObject((Map)opt);
        }
        return (JsonObject)opt;
    }

    public JsonArray getJsonArray(int index) {
        this.assertIndex(index, this.size());
        Object opt = this.jsonArray.opt(index);
        if (opt instanceof org.json.JSONArray) {
            return new JSONArray((org.json.JSONArray)opt);
        }
        if (opt instanceof List) {
            return new JSONArray((List)opt);
        }
        return (JsonArray)opt;
    }

    public JsonArray remove(int index) {
        this.assertIndex(index, this.size());
        Object remove = this.jsonArray.remove(index);
        return this;
    }

    public JsonArray clear() {
        int length = this.jsonArray.length();
        for (int i = 0; i < length; ++i) {
            this.jsonArray.remove(i);
        }
        return this;
    }

    public JsonArray put(Object o) {
        this.jsonArray.put(o);
        return this;
    }

    public JsonArray put(int index, Object o) {
        this.jsonArray.put(index, o);
        return this;
    }

    public JsonArray putAll(Collection<?> os) {
        os.forEach(v -> this.jsonArray.put(v));
        return this;
    }

    public String toString() {
        HashMap<Integer, Json> map = new HashMap<Integer, Json>();
        int size = this.size();
        for (int i = 0; i < size; ++i) {
            Object o = this.jsonArray.get(i);
            if (!(o instanceof JsonObject) && !(o instanceof JsonArray)) continue;
            map.put(i, (Json)o);
        }
        map.forEach((k, v) -> this.jsonArray.put(k.intValue(), v.unwrap()));
        return this.jsonArray.toString();
    }

    public int hashCode() {
        return this.jsonArray.hashCode();
    }

    public boolean equals(Object obj) {
        return this.jsonArray.equals(obj);
    }

    public JsonArray fromList(List<Object> list) {
        this.jsonArray = new org.json.JSONArray(list);
        return this;
    }
}

