/*
 * Decompiled with CFR 0.152.
 */
package top.jfunc.json.util;

import java.io.Closeable;
import java.io.IOException;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.util.HashMap;
import java.util.Locale;
import java.util.Map;
import org.json.JSONObject;
import top.jfunc.json.annotation.JsonField;

public class Bean2Map {
    public static Map<String, Object> convert(Object javaBean, boolean nullHold, String ... ignoreFields) {
        Method[] methods;
        Class<?> klass = javaBean.getClass();
        boolean includeSuperClass = klass.getClassLoader() != null;
        Method[] methodArray = methods = includeSuperClass ? klass.getMethods() : klass.getDeclaredMethods();
        if (null == methods || 0 == methods.length) {
            return new HashMap<String, Object>(0);
        }
        HashMap<String, Object> map = new HashMap<String, Object>(methods.length);
        for (Method method : methods) {
            String key;
            int modifiers;
            JsonField annotation = method.getAnnotation(JsonField.class);
            if (null != annotation && !annotation.serialize() || !Modifier.isPublic(modifiers = method.getModifiers()) || Modifier.isStatic(modifiers) || method.getParameterTypes().length != 0 || method.isBridge() || method.getReturnType() == Void.TYPE) continue;
            String name = method.getName();
            if (name.startsWith("get")) {
                if ("getClass".equals(name) || "getDeclaringClass".equals(name)) continue;
                key = name.substring(3);
            } else {
                if (!name.startsWith("is")) continue;
                key = name.substring(2);
            }
            if (key.length() <= 0 || !Character.isUpperCase(key.charAt(0))) continue;
            if (key.length() == 1) {
                key = key.toLowerCase(Locale.ROOT);
            } else if (!Character.isUpperCase(key.charAt(1))) {
                key = key.substring(0, 1).toLowerCase(Locale.ROOT) + key.substring(1);
            }
            if (Bean2Map.shouldIgnore(ignoreFields, key)) continue;
            if (null != annotation && !"".equals(annotation.value())) {
                key = annotation.value();
            }
            try {
                Object result = method.invoke(javaBean, new Object[0]);
                if (!nullHold && result == null) continue;
                map.put(key, JSONObject.wrap((Object)result));
                if (!(result instanceof Closeable)) continue;
                try {
                    ((Closeable)result).close();
                }
                catch (IOException iOException) {}
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return map;
    }

    private static boolean shouldIgnore(String[] ignoreFields, String fieldName) {
        if (ignoreFields == null || ignoreFields.length == 0) {
            return false;
        }
        for (int i = 0; i < ignoreFields.length; ++i) {
            if (!fieldName.equals(ignoreFields[i])) continue;
            return true;
        }
        return false;
    }
}

