/*
 * Decompiled with CFR 0.152.
 */
package top.jfunc.json.util;

import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Date;
import java.util.List;
import java.util.Map;
import top.jfunc.json.impl.ValueCompatible;

public class Map2Bean {
    private Map2Bean() {
    }

    public static <T> T convert(Map<String, Object> map, Class<T> clazz) {
        try {
            T instance = clazz.newInstance();
            ArrayList<Field> fields = new ArrayList<Field>();
            Map2Bean.parseAllFields(clazz, fields);
            for (Field field : fields) {
                String fieldName = field.getName();
                Class<?> type = field.getType();
                if (!Map2Bean.canSetValueDirectly(type)) {
                    Map2Bean.setValue(instance, field, Map2Bean.convert(map, type));
                    continue;
                }
                Object value = map.get(fieldName);
                if (null == value) continue;
                Map2Bean.setValue(instance, field, value);
            }
            return instance;
        }
        catch (Exception e) {
            e.printStackTrace();
            throw new RuntimeException(e);
        }
    }

    private static void parseAllFields(Class<?> clazz, List<Field> list) {
        if (clazz != Object.class) {
            Field[] fields = clazz.getDeclaredFields();
            list.addAll(Arrays.asList(fields));
            Map2Bean.parseAllFields(clazz.getSuperclass(), list);
        }
    }

    public static boolean canSetValueDirectly(Class<?> clazz) {
        return clazz.isPrimitive() || clazz == String.class || clazz == Character.class || clazz == Boolean.class || Number.class.isAssignableFrom(clazz) || Date.class.isAssignableFrom(clazz);
    }

    public static <T> void setValue(T instance, Field field, Object v) {
        field.setAccessible(true);
        try {
            v = ValueCompatible.compatibleValue((Object)v, field.getType());
            field.set(instance, v);
        }
        catch (IllegalAccessException e) {
            e.printStackTrace();
        }
    }
}

