/*
 * Decompiled with CFR 0.152.
 */
package top.osjf.assembly.cache.autoconfigure;

import java.util.Arrays;
import java.util.concurrent.TimeUnit;
import javax.annotation.PostConstruct;
import net.jodah.expiringmap.ExpirationPolicy;
import org.springframework.boot.context.properties.ConfigurationProperties;
import top.osjf.assembly.cache.autoconfigure.SourceEnvironmentPostProcessor;
import top.osjf.assembly.cache.persistence.ByteCachePersistence;
import top.osjf.assembly.cache.persistence.CachePersistenceReduction;
import top.osjf.assembly.util.SystemUtils;

@ConfigurationProperties(prefix="assembly.cache")
public class CacheProperties {
    private Boolean openPersistence = false;
    private Boolean persistenceAsync = false;
    private Class<? extends CachePersistenceReduction> persistenceReductionClass = ByteCachePersistence.class;
    private String persistencePath = SystemUtils.getCurrentProjectPath() + "/expire/";
    private String[] listeningRecoverySubPath = SourceEnvironmentPostProcessor.findSpringbootPrimarySourcesPackages();
    private Long noPersistenceOfExpireTime = 20L;
    private TimeUnit noPersistenceOfExpireTimeUnit = TimeUnit.SECONDS;
    private Long defaultExpireTime = 30L;
    private TimeUnit defaultExpireTimeUnit = TimeUnit.SECONDS;
    private Client client = Client.EXPIRE_MAP;
    private ExpiringMap expiringMap = new ExpiringMap();

    public Boolean getOpenPersistence() {
        return this.openPersistence;
    }

    public void setOpenPersistence(Boolean openPersistence) {
        this.openPersistence = openPersistence;
    }

    public Boolean getPersistenceAsync() {
        return this.persistenceAsync;
    }

    public void setPersistenceAsync(Boolean persistenceAsync) {
        this.persistenceAsync = persistenceAsync;
    }

    public Class<? extends CachePersistenceReduction> getPersistenceReductionClass() {
        return this.persistenceReductionClass;
    }

    public void setPersistenceReductionClass(Class<? extends CachePersistenceReduction> persistenceReductionClass) {
        this.persistenceReductionClass = persistenceReductionClass;
    }

    public String getPersistencePath() {
        return this.persistencePath;
    }

    public void setPersistencePath(String persistencePath) {
        this.persistencePath = persistencePath;
    }

    public Long getNoPersistenceOfExpireTime() {
        return this.noPersistenceOfExpireTime;
    }

    public void setNoPersistenceOfExpireTime(Long noPersistenceOfExpireTime) {
        this.noPersistenceOfExpireTime = noPersistenceOfExpireTime;
    }

    public TimeUnit getNoPersistenceOfExpireTimeUnit() {
        return this.noPersistenceOfExpireTimeUnit;
    }

    public void setNoPersistenceOfExpireTimeUnit(TimeUnit noPersistenceOfExpireTimeUnit) {
        this.noPersistenceOfExpireTimeUnit = noPersistenceOfExpireTimeUnit;
    }

    public String[] getListeningRecoverySubPath() {
        return this.listeningRecoverySubPath;
    }

    public void setListeningRecoverySubPath(String[] listeningRecoverySubPath) {
        this.listeningRecoverySubPath = listeningRecoverySubPath;
    }

    public Long getDefaultExpireTime() {
        return this.defaultExpireTime;
    }

    public void setDefaultExpireTime(Long defaultExpireTime) {
        this.defaultExpireTime = defaultExpireTime;
    }

    public TimeUnit getDefaultExpireTimeUnit() {
        return this.defaultExpireTimeUnit;
    }

    public void setDefaultExpireTimeUnit(TimeUnit defaultExpireTimeUnit) {
        this.defaultExpireTimeUnit = defaultExpireTimeUnit;
    }

    public Client getClient() {
        return this.client;
    }

    public void setClient(Client client) {
        this.client = client;
    }

    public ExpiringMap getExpiringMap() {
        return this.expiringMap;
    }

    public void setExpiringMap(ExpiringMap expiringMap) {
        this.expiringMap = expiringMap;
    }

    @PostConstruct
    public void initForPersistenceConfiguration() {
        SystemUtils.setProperty((Object)"assembly.cache.open.persistence", (Object)this.openPersistence);
        SystemUtils.setProperty((Object)"assembly.cache.persistence.run.async", (Object)this.persistenceAsync);
        SystemUtils.setProperty((Object)"assembly.cache.persistence.path", (Object)this.persistencePath);
        SystemUtils.setProperty((Object)"assembly.cache.default.expire.time", (Object)this.defaultExpireTime);
        SystemUtils.setProperty((Object)"assembly.cache.default.expire.timeUnit", (Object)((Object)this.defaultExpireTimeUnit));
        SystemUtils.setProperty((Object)"assembly.cache.noPersistence.expire.time", (Object)this.noPersistenceOfExpireTime);
        SystemUtils.setProperty((Object)"assembly.cache.noPersistence.expire.timeUnit", (Object)((Object)this.noPersistenceOfExpireTimeUnit));
        SystemUtils.setProperty((Object)"assembly.cache.choose.client", (Object)this.client.name());
        SystemUtils.setProperty((Object)"assembly.cache.listening.recovery.path", (Object)Arrays.toString(this.listeningRecoverySubPath));
    }

    public static enum Client {
        EXPIRE_MAP;

    }

    public static class ExpiringMap {
        private Integer maxSize = 500;
        private ExpirationPolicy expirationPolicy = ExpirationPolicy.ACCESSED;
        private String[] listeningPackages = SourceEnvironmentPostProcessor.findSpringbootPrimarySourcesPackages();

        public Integer getMaxSize() {
            return this.maxSize;
        }

        public void setMaxSize(Integer maxSize) {
            this.maxSize = maxSize;
        }

        public ExpirationPolicy getExpirationPolicy() {
            return this.expirationPolicy;
        }

        public void setExpirationPolicy(ExpirationPolicy expirationPolicy) {
            this.expirationPolicy = expirationPolicy;
        }

        public String[] getListeningPackages() {
            return this.listeningPackages;
        }

        public void setListeningPackages(String[] listeningPackages) {
            this.listeningPackages = listeningPackages;
        }
    }
}

