/*
 * Decompiled with CFR 0.152.
 */
package top.osjf.assembly.cache.autoconfigure;

import cn.hutool.core.util.ReflectUtil;
import java.io.PrintStream;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.function.Predicate;
import net.jodah.expiringmap.ExpirationListener;
import net.jodah.expiringmap.ExpiringMap;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.collections4.MapUtils;
import org.apache.commons.lang3.ArrayUtils;
import org.springframework.beans.factory.ObjectProvider;
import org.springframework.boot.autoconfigure.condition.ConditionalOnClass;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.context.EnvironmentAware;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.core.env.Environment;
import top.osjf.assembly.cache.autoconfigure.CacheBannerDisplayDevice;
import top.osjf.assembly.cache.autoconfigure.CacheCommonsConfiguration;
import top.osjf.assembly.cache.autoconfigure.CacheProperties;
import top.osjf.assembly.cache.autoconfigure.ExpiringMapBanner;
import top.osjf.assembly.cache.autoconfigure.StartUpBanner;
import top.osjf.assembly.cache.autoconfigure.StartUpBannerExecutor;
import top.osjf.assembly.cache.config.expiringmap.ExpiringMapClients;
import top.osjf.assembly.cache.config.expiringmap.ExpiringMapClientsCustomizer;
import top.osjf.assembly.cache.factory.CacheFactory;
import top.osjf.assembly.cache.factory.ExpiringMapCacheFactory;
import top.osjf.assembly.cache.listener.expiringmap.AsyncListener;
import top.osjf.assembly.cache.listener.expiringmap.SyncListener;
import top.osjf.assembly.cache.logger.Console;
import top.osjf.assembly.util.DefaultConsole;
import top.osjf.assembly.util.ScanUtils;
import top.osjf.assembly.util.annotation.NotNull;

@Configuration(proxyBeanMethods=false)
@ConditionalOnClass(value={ExpiringMap.class})
@ConditionalOnProperty(name={"assembly.cache.client"}, havingValue="expire_map", matchIfMissing=true)
public class ExpiringMapConfiguration
extends CacheCommonsConfiguration
implements CacheBannerDisplayDevice,
EnvironmentAware {
    private Environment environment;
    static final String SYNC_SIGN = "SYNC";
    static final String ASYNC_SIGN = "ASYNC";
    static String EXPIRED_METHOD_NAME;
    static Predicate<Method> METHOD_PREDICATE;

    public ExpiringMapConfiguration(CacheProperties properties) {
        super(properties);
    }

    @Override
    public void printBanner(Environment environment, Class<?> sourceClass, PrintStream out) {
        StartUpBannerExecutor.printBanner(environment, this.getStartUpBanner(), sourceClass, out);
    }

    public void setEnvironment(@NotNull Environment environment) {
        this.environment = environment;
    }

    @Override
    @NotNull
    public Environment getEnvironment() {
        return this.environment;
    }

    @Override
    @NotNull
    public Class<?> getSourceClass() {
        return ExpiringMap.class;
    }

    @Override
    @NotNull
    public StartUpBanner getStartUpBanner() {
        return new ExpiringMapBanner();
    }

    @Bean(value={"expiringMap::cacheExecutorFactory"})
    @ConditionalOnMissingBean(value={CacheFactory.class})
    public CacheFactory cacheExecutorFactory(ObjectProvider<ExpiringMapClientsCustomizer> buildCustomizer) {
        ExpiringMapClients.ExpiringMapClientsBuilder builder = ExpiringMapClients.builder();
        buildCustomizer.orderedStream().forEach(customizer -> customizer.customize(builder));
        return new ExpiringMapCacheFactory((ExpiringMapClients)builder.build());
    }

    @Bean(value={"expiringMap::expireMapClientCustomizer"})
    public ExpiringMapClientsCustomizer expireMapClientCustomizer() {
        CacheProperties properties = this.getProperties();
        return c -> {
            ExpiringMapClients.ExpiringMapClientsBuilder builder = c.acquireMaxSize(properties.getExpiringMap().getMaxSize()).acquireDefaultExpireTime(properties.getDefaultExpireTime()).acquireDefaultExpireTimeUnit(properties.getDefaultExpireTimeUnit()).acquireDefaultExpirationPolicy(properties.getExpiringMap().getExpirationPolicy());
            Map<String, List<ExpirationListener>> listenerMap = this.findExpirationListener();
            if (MapUtils.isNotEmpty(listenerMap)) {
                List<ExpirationListener> async;
                List<ExpirationListener> sync = listenerMap.get(SYNC_SIGN);
                if (CollectionUtils.isNotEmpty(sync)) {
                    sync.forEach(arg_0 -> ((ExpiringMapClients.ExpiringMapClientsBuilder)builder).addSyncExpiredListener(arg_0));
                }
                if (CollectionUtils.isNotEmpty(async = listenerMap.get(ASYNC_SIGN))) {
                    async.forEach(arg_0 -> ((ExpiringMapClients.ExpiringMapClientsBuilder)builder).addASyncExpiredListener(arg_0));
                }
            }
        };
    }

    public Map<String, List<ExpirationListener>> findExpirationListener() {
        Object[] listeningPackages = this.getProperties().getExpiringMap().getListeningPackages();
        if (ArrayUtils.isEmpty((Object[])listeningPackages)) {
            DefaultConsole.info((String)"no provider listening scan path ,so ec no can provider binding Expiration Listener !", (Object[])new Object[0]);
            return Collections.emptyMap();
        }
        Set subTypesOf = ScanUtils.getSubTypesOf(ExpirationListener.class, (String[])listeningPackages);
        if (CollectionUtils.isEmpty((Collection)subTypesOf)) {
            DefaultConsole.info((String)"No provider implementation ExpiringLoadListener class ,so ec no can provider binding Expiration Listener", (Object[])new Object[0]);
            return Collections.emptyMap();
        }
        ArrayList<ExpirationListener> sync = new ArrayList<ExpirationListener>();
        ArrayList<ExpirationListener> async = new ArrayList<ExpirationListener>();
        HashMap<String, List<ExpirationListener>> listenerMap = new HashMap<String, List<ExpirationListener>>();
        for (Class listenerClass : subTypesOf) {
            ExpirationListener listener;
            Method target;
            if (Modifier.isAbstract(listenerClass.getModifiers()) || Modifier.isInterface(listenerClass.getModifiers()) || Arrays.stream(listenerClass.getMethods()).noneMatch(METHOD_PREDICATE) || (target = (Method)Arrays.stream(listenerClass.getMethods()).filter(METHOD_PREDICATE).findFirst().orElse(null)) == null) continue;
            try {
                listener = (ExpirationListener)ReflectUtil.newInstance((Class)listenerClass, (Object[])new Object[0]);
            }
            catch (Throwable e) {
                Console.warn((String)("[" + listenerClass.getName() + "] newInstanceForNoArgs failed : [" + e.getMessage() + "]"), (Object[])new Object[0]);
                continue;
            }
            SyncListener syncListener = listenerClass.getAnnotation(SyncListener.class);
            if (syncListener == null) {
                AsyncListener asyncListener = listenerClass.getAnnotation(AsyncListener.class);
                if (asyncListener == null) continue;
                async.add(listener);
                continue;
            }
            sync.add(listener);
        }
        listenerMap.put(SYNC_SIGN, sync);
        listenerMap.put(ASYNC_SIGN, async);
        return listenerMap;
    }

    static {
        Object[] methods = ExpirationListener.class.getMethods();
        if (ArrayUtils.isNotEmpty((Object[])methods)) {
            EXPIRED_METHOD_NAME = ((Method)methods[0]).getName();
            METHOD_PREDICATE = s -> EXPIRED_METHOD_NAME.equals(s.getName());
        }
    }
}

