/*
 * Decompiled with CFR 0.152.
 */
package top.osjf.assembly.cache.autoconfigure;

import java.util.Objects;
import java.util.Set;
import org.springframework.boot.SpringApplication;
import org.springframework.boot.env.EnvironmentPostProcessor;
import org.springframework.core.Ordered;
import org.springframework.core.env.ConfigurableEnvironment;
import top.osjf.assembly.util.annotation.NotNull;

public class SourceEnvironmentPostProcessor
implements EnvironmentPostProcessor,
Ordered {
    private static String[] springbootPrimarySourcesPackages;

    public void postProcessEnvironment(ConfigurableEnvironment environment, SpringApplication application) {
        this.applicationSource(application.getAllSources());
    }

    public int getOrder() {
        return -2147483635;
    }

    public static String[] findSpringbootPrimarySourcesPackages() {
        return springbootPrimarySourcesPackages;
    }

    private void applicationSource(@NotNull Set<Object> source) {
        if (source.isEmpty()) {
            throw new IllegalArgumentException("No detection of the existence of the startup main class");
        }
        springbootPrimarySourcesPackages = (String[])source.stream().map(o -> {
            if (o instanceof Class) {
                return ((Class)o).getName().split("\\." + ((Class)o).getSimpleName())[0];
            }
            return null;
        }).filter(Objects::nonNull).toArray(String[]::new);
    }
}

