/*
 * Decompiled with CFR 0.152.
 */
package top.osjf.assembly.cache.autoconfigure;

import java.io.PrintStream;
import java.util.List;
import org.springframework.beans.factory.ObjectProvider;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.boot.autoconfigure.condition.ConditionalOnBean;
import org.springframework.boot.autoconfigure.condition.ConditionalOnClass;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.context.EnvironmentAware;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.context.annotation.Import;
import org.springframework.core.env.Environment;
import top.osjf.assembly.cache.autoconfigure.CacheBannerDisplayDevice;
import top.osjf.assembly.cache.autoconfigure.CacheProperties;
import top.osjf.assembly.cache.autoconfigure.CacheStarterBanner;
import top.osjf.assembly.cache.autoconfigure.ConfigurationCustomizer;
import top.osjf.assembly.cache.autoconfigure.ExpiringMapConfiguration;
import top.osjf.assembly.cache.autoconfigure.PersistenceReductionProcess;
import top.osjf.assembly.cache.autoconfigure.StartUpBanner;
import top.osjf.assembly.cache.autoconfigure.StartUpBannerExecutor;
import top.osjf.assembly.cache.factory.CacheFactory;
import top.osjf.assembly.cache.operations.CacheCommonsOperations;
import top.osjf.assembly.cache.operations.CacheTemplate;
import top.osjf.assembly.cache.operations.StringCacheTemplate;
import top.osjf.assembly.cache.operations.TimeOperations;
import top.osjf.assembly.cache.operations.ValueOperations;
import top.osjf.assembly.cache.serializer.PairSerializer;
import top.osjf.assembly.cache.serializer.SerializerAdapter;
import top.osjf.assembly.cache.serializer.StringPairSerializer;
import top.osjf.assembly.util.annotation.NotNull;
import top.osjf.assembly.util.lang.CollectionUtils;

@Configuration(proxyBeanMethods=false)
@ConditionalOnClass(value={CacheCommonsOperations.class})
@EnableConfigurationProperties(value={CacheProperties.class})
@Import(value={ExpiringMapConfiguration.class})
public class CacheAutoConfiguration
implements CacheBannerDisplayDevice,
EnvironmentAware {
    public static final String DEFAULT_SO_TEMPLATE = "DEFAULT_SO_TEMPLATE";
    public static final String OPERATION = "_OPERATION";
    public static final String OPERATION_E = "_OPERATION_E";
    public static final String DEFAULT_SO_TEMPLATE_OPERATION = "DEFAULT_SO_TEMPLATE_OPERATION";
    public static final String DEFAULT_SO_TEMPLATE_OPERATION_E = "DEFAULT_SO_TEMPLATE_OPERATION_E";
    public static final String DEFAULT_SS_TEMPLATE = "DEFAULT_SS_TEMPLATE";
    public static final String DEFAULT_SS_TEMPLATE_OPERATION = "DEFAULT_SS_TEMPLATE_OPERATION";
    public static final String DEFAULT_SS_TEMPLATE_OPERATION_E = "DEFAULT_SS_TEMPLATE_OPERATION_E";
    private final CacheProperties properties;
    private final List<ConfigurationCustomizer> configurationCustomizers;
    public Environment environment;

    public CacheAutoConfiguration(CacheProperties properties, ObjectProvider<List<ConfigurationCustomizer>> listObjectProvider) {
        this.properties = properties;
        this.configurationCustomizers = (List)listObjectProvider.getIfAvailable();
    }

    @Override
    public void afterPropertiesSet() {
        this.printBanner(this.environment, this.getSourceClass(), System.out);
        if (CollectionUtils.isNotEmpty(this.configurationCustomizers)) {
            this.configurationCustomizers.forEach(v -> v.customize(this.properties));
        }
    }

    @Override
    public void printBanner(Environment environment, Class<?> sourceClass, PrintStream out) {
        StartUpBannerExecutor.printBanner(environment, this.getStartUpBanner(), sourceClass, out);
    }

    @Override
    @NotNull
    public Environment getEnvironment() {
        return this.environment;
    }

    public void setEnvironment(@NotNull Environment environment) {
        this.environment = environment;
    }

    @Override
    @NotNull
    public StartUpBanner getStartUpBanner() {
        return new CacheStarterBanner();
    }

    @Bean(value={"DEFAULT_SO_TEMPLATE"})
    @ConditionalOnMissingBean(name={"DEFAULT_SO_TEMPLATE"})
    public CacheTemplate<String, Object> cacheTemplate(CacheFactory factory) {
        CacheTemplate template = new CacheTemplate();
        template.setCacheFactory(factory);
        template.setKeySerializer((PairSerializer)new StringPairSerializer());
        template.setValueSerializer((PairSerializer)new SerializerAdapter(Object.class));
        return template;
    }

    @Bean(value={"DEFAULT_SS_TEMPLATE"})
    @ConditionalOnMissingBean(name={"DEFAULT_SS_TEMPLATE"})
    public StringCacheTemplate stringCacheTemplate(CacheFactory factory) {
        StringCacheTemplate template = new StringCacheTemplate();
        template.setCacheFactory(factory);
        return template;
    }

    @Bean(value={"DEFAULT_SO_TEMPLATE_OPERATION"})
    @ConditionalOnBean(name={"DEFAULT_SO_TEMPLATE"})
    @ConditionalOnMissingBean(name={"DEFAULT_SO_TEMPLATE_OPERATION"})
    public ValueOperations<String, Object> valueOperations(@Qualifier(value="DEFAULT_SO_TEMPLATE") CacheTemplate<String, Object> template) {
        return template.opsForValue();
    }

    @Bean(value={"DEFAULT_SS_TEMPLATE_OPERATION"})
    @ConditionalOnBean(name={"DEFAULT_SS_TEMPLATE"})
    @ConditionalOnMissingBean(name={"DEFAULT_SS_TEMPLATE_OPERATION"})
    public ValueOperations<String, String> valueOperations(@Qualifier(value="DEFAULT_SS_TEMPLATE") StringCacheTemplate template) {
        return template.opsForValue();
    }

    @Bean(value={"DEFAULT_SO_TEMPLATE_OPERATION_E"})
    @ConditionalOnBean(name={"DEFAULT_SO_TEMPLATE"})
    @ConditionalOnMissingBean(name={"DEFAULT_SO_TEMPLATE_OPERATION_E"})
    public TimeOperations<String, Object> timeOperations(@Qualifier(value="DEFAULT_SO_TEMPLATE") CacheTemplate<String, Object> template) {
        return template.opsForTime();
    }

    @Bean(value={"DEFAULT_SS_TEMPLATE_OPERATION_E"})
    @ConditionalOnBean(name={"DEFAULT_SS_TEMPLATE"})
    @ConditionalOnMissingBean(name={"DEFAULT_SS_TEMPLATE_OPERATION_E"})
    public TimeOperations<String, String> timeOperations(@Qualifier(value="DEFAULT_SS_TEMPLATE") StringCacheTemplate template) {
        return template.opsForTime();
    }

    @Bean
    @ConditionalOnProperty(prefix="assembly.cache", name={"open-persistence"}, havingValue="true")
    @ConditionalOnBean(value={CacheTemplate.class})
    public PersistenceReductionProcess assemblyCachePersistenceReduction(@Value(value="${assembly.cache.persistence-path:default}") String path) {
        return new PersistenceReductionProcess(path, this.properties.getPersistenceReductionClass());
    }
}

