/*
 * Decompiled with CFR 0.152.
 */
package top.osjf.assembly.cache.autoconfigure;

import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.TimeUnit;
import javax.annotation.PostConstruct;
import net.jodah.expiringmap.ExpirationPolicy;
import org.springframework.boot.context.properties.ConfigurationProperties;
import top.osjf.assembly.cache.autoconfigure.SourceEnvironmentPostProcessor;
import top.osjf.assembly.cache.config.Configuration;
import top.osjf.assembly.cache.listener.ExpirationMessageListener;
import top.osjf.assembly.cache.persistence.ByteCachePersistence;
import top.osjf.assembly.cache.persistence.CachePersistenceReduction;
import top.osjf.assembly.cache.persistence.ListeningRecovery;
import top.osjf.assembly.util.lang.CollectionUtils;
import top.osjf.assembly.util.system.SystemUtils;

@ConfigurationProperties(prefix="assembly.cache")
public class CacheProperties {
    private Boolean openPersistence = false;
    private Boolean persistenceAsync = false;
    private Class<? extends CachePersistenceReduction> persistenceReductionClass = ByteCachePersistence.class;
    private String persistencePath = SystemUtils.getCurrentProjectPath() + "/expire/";
    private List<Class<? extends ListeningRecovery>> listeningRecoveries = new ArrayList<Class<? extends ListeningRecovery>>();
    private List<String> listeningRecoveryScanPath;
    private List<Class<? extends ExpirationMessageListener>> expirationMessageListeners = new ArrayList<Class<? extends ExpirationMessageListener>>();
    private List<String> expirationMessageListenersScanPath;
    private Long noPersistenceOfExpireTime = 20L;
    private TimeUnit noPersistenceOfExpireTimeUnit = TimeUnit.SECONDS;
    private Long defaultExpireTime = 30L;
    private TimeUnit defaultExpireTimeUnit = TimeUnit.SECONDS;
    private Client client = Client.EXPIRE_MAP;
    private ExpiringMap expiringMap = new ExpiringMap();

    public Boolean getOpenPersistence() {
        return this.openPersistence;
    }

    public void setOpenPersistence(Boolean openPersistence) {
        this.openPersistence = openPersistence;
    }

    public Boolean getPersistenceAsync() {
        return this.persistenceAsync;
    }

    public void setPersistenceAsync(Boolean persistenceAsync) {
        this.persistenceAsync = persistenceAsync;
    }

    public Class<? extends CachePersistenceReduction> getPersistenceReductionClass() {
        return this.persistenceReductionClass;
    }

    public void setPersistenceReductionClass(Class<? extends CachePersistenceReduction> persistenceReductionClass) {
        this.persistenceReductionClass = persistenceReductionClass;
    }

    public String getPersistencePath() {
        return this.persistencePath;
    }

    public void setPersistencePath(String persistencePath) {
        this.persistencePath = persistencePath;
    }

    public Long getNoPersistenceOfExpireTime() {
        return this.noPersistenceOfExpireTime;
    }

    public void setNoPersistenceOfExpireTime(Long noPersistenceOfExpireTime) {
        this.noPersistenceOfExpireTime = noPersistenceOfExpireTime;
    }

    public TimeUnit getNoPersistenceOfExpireTimeUnit() {
        return this.noPersistenceOfExpireTimeUnit;
    }

    public void setNoPersistenceOfExpireTimeUnit(TimeUnit noPersistenceOfExpireTimeUnit) {
        this.noPersistenceOfExpireTimeUnit = noPersistenceOfExpireTimeUnit;
    }

    public List<Class<? extends ListeningRecovery>> getListeningRecoveries() {
        return this.listeningRecoveries;
    }

    public void setListeningRecoveries(List<Class<? extends ListeningRecovery>> listeningRecoveries) {
        this.listeningRecoveries = listeningRecoveries;
    }

    public List<String> getListeningRecoveryScanPath() {
        return this.listeningRecoveryScanPath;
    }

    public void setListeningRecoveryScanPath(List<String> listeningRecoveryScanPath) {
        this.listeningRecoveryScanPath = listeningRecoveryScanPath;
    }

    public List<Class<? extends ExpirationMessageListener>> getExpirationMessageListeners() {
        return this.expirationMessageListeners;
    }

    public void setExpirationMessageListeners(List<Class<? extends ExpirationMessageListener>> expirationMessageListeners) {
        this.expirationMessageListeners = expirationMessageListeners;
    }

    public List<String> getExpirationMessageListenersScanPath() {
        return this.expirationMessageListenersScanPath;
    }

    public void setExpirationMessageListenersScanPath(List<String> expirationMessageListenersScanPath) {
        this.expirationMessageListenersScanPath = expirationMessageListenersScanPath;
    }

    public Long getDefaultExpireTime() {
        return this.defaultExpireTime;
    }

    public void setDefaultExpireTime(Long defaultExpireTime) {
        this.defaultExpireTime = defaultExpireTime;
    }

    public TimeUnit getDefaultExpireTimeUnit() {
        return this.defaultExpireTimeUnit;
    }

    public void setDefaultExpireTimeUnit(TimeUnit defaultExpireTimeUnit) {
        this.defaultExpireTimeUnit = defaultExpireTimeUnit;
    }

    public Client getClient() {
        return this.client;
    }

    public void setClient(Client client) {
        this.client = client;
    }

    public ExpiringMap getExpiringMap() {
        return this.expiringMap;
    }

    public void setExpiringMap(ExpiringMap expiringMap) {
        this.expiringMap = expiringMap;
    }

    @PostConstruct
    public void initForPersistenceConfiguration() {
        if (CollectionUtils.isEmpty(this.listeningRecoveries)) {
            if (CollectionUtils.isEmpty(this.listeningRecoveryScanPath)) {
                this.listeningRecoveryScanPath = SourceEnvironmentPostProcessor.findSpringbootPrimarySourcesPackages();
            }
            Configuration.scanListeningRecoveryWithPaths(this.listeningRecoveryScanPath);
        } else {
            this.listeningRecoveries.forEach(Configuration::addListeningRecovery);
        }
        if (CollectionUtils.isEmpty(this.expirationMessageListeners)) {
            if (CollectionUtils.isEmpty(this.expirationMessageListenersScanPath)) {
                this.expirationMessageListenersScanPath = SourceEnvironmentPostProcessor.findSpringbootPrimarySourcesPackages();
            }
            Configuration.scanExpirationMessageListenerWithPaths(this.expirationMessageListenersScanPath);
        } else {
            this.expirationMessageListeners.forEach(Configuration::addExpirationMessageListener);
        }
        SystemUtils.setProperty((Object)"assembly.cache.open.persistence", (Object)this.openPersistence);
        SystemUtils.setProperty((Object)"assembly.cache.persistence.run.async", (Object)this.persistenceAsync);
        SystemUtils.setProperty((Object)"assembly.cache.persistence.path", (Object)this.persistencePath);
        SystemUtils.setProperty((Object)"assembly.cache.default.expire.time", (Object)this.defaultExpireTime);
        SystemUtils.setProperty((Object)"assembly.cache.default.expire.timeUnit", (Object)((Object)this.defaultExpireTimeUnit));
        SystemUtils.setProperty((Object)"assembly.cache.noPersistence.expire.time", (Object)this.noPersistenceOfExpireTime);
        SystemUtils.setProperty((Object)"assembly.cache.noPersistence.expire.timeUnit", (Object)((Object)this.noPersistenceOfExpireTimeUnit));
    }

    public static enum Client {
        EXPIRE_MAP;

    }

    public static class ExpiringMap {
        private Integer maxSize = 500;
        private ExpirationPolicy expirationPolicy = ExpirationPolicy.ACCESSED;

        public Integer getMaxSize() {
            return this.maxSize;
        }

        public void setMaxSize(Integer maxSize) {
            this.maxSize = maxSize;
        }

        public ExpirationPolicy getExpirationPolicy() {
            return this.expirationPolicy;
        }

        public void setExpirationPolicy(ExpirationPolicy expirationPolicy) {
            this.expirationPolicy = expirationPolicy;
        }
    }
}

