/*
 * Decompiled with CFR 0.152.
 */
package top.osjf.assembly.cache.autoconfigure;

import java.io.PrintStream;
import net.jodah.expiringmap.ExpiringMap;
import org.springframework.boot.autoconfigure.condition.ConditionalOnClass;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.context.EnvironmentAware;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.core.env.Environment;
import top.osjf.assembly.cache.autoconfigure.CacheBannerDisplayDevice;
import top.osjf.assembly.cache.autoconfigure.CacheCommonsConfiguration;
import top.osjf.assembly.cache.autoconfigure.CacheProperties;
import top.osjf.assembly.cache.autoconfigure.ExpiringMapBanner;
import top.osjf.assembly.cache.autoconfigure.StartUpBanner;
import top.osjf.assembly.cache.autoconfigure.StartUpBannerExecutor;
import top.osjf.assembly.cache.config.expiringmap.ExpiringMapClients;
import top.osjf.assembly.cache.factory.CacheFactory;
import top.osjf.assembly.cache.factory.ExpiringMapCacheFactory;
import top.osjf.assembly.util.annotation.NotNull;

@Configuration(proxyBeanMethods=false)
@ConditionalOnClass(value={ExpiringMap.class})
@ConditionalOnProperty(name={"assembly.cache.client"}, havingValue="expire_map", matchIfMissing=true)
public class ExpiringMapConfiguration
extends CacheCommonsConfiguration
implements CacheBannerDisplayDevice,
EnvironmentAware {
    private Environment environment;

    public ExpiringMapConfiguration(CacheProperties properties) {
        super(properties);
    }

    @Override
    public void printBanner(Environment environment, Class<?> sourceClass, PrintStream out) {
        StartUpBannerExecutor.printBanner(environment, this.getStartUpBanner(), sourceClass, out);
    }

    public void setEnvironment(@NotNull Environment environment) {
        this.environment = environment;
    }

    @Override
    @NotNull
    public Environment getEnvironment() {
        return this.environment;
    }

    @Override
    @NotNull
    public Class<?> getSourceClass() {
        return ExpiringMap.class;
    }

    @Override
    @NotNull
    public StartUpBanner getStartUpBanner() {
        return new ExpiringMapBanner();
    }

    @Bean
    @ConditionalOnMissingBean(value={CacheFactory.class})
    public CacheFactory expiringMapCacheExecutorFactory() {
        CacheProperties properties = this.getProperties();
        CacheProperties.ExpiringMap expiringMap = properties.getExpiringMap();
        ExpiringMapClients.ExpiringMapClientsBuilder builder = ExpiringMapClients.builder().acquireMaxSize(expiringMap.getMaxSize()).acquireDefaultExpireTime(properties.getDefaultExpireTime()).acquireDefaultExpireTimeUnit(properties.getDefaultExpireTimeUnit()).acquireDefaultExpirationPolicy(expiringMap.getExpirationPolicy());
        return new ExpiringMapCacheFactory((ExpiringMapClients)builder.build());
    }
}

