/*
 * Decompiled with CFR 0.152.
 */
package top.osjf.assembly.cache.autoconfigure;

import javax.annotation.PostConstruct;
import top.osjf.assembly.cache.persistence.CachePersistenceReduction;
import top.osjf.assembly.util.lang.ReflectUtils;
import top.osjf.assembly.util.lang.StringUtils;

public class PersistenceReductionProcess {
    private final String path;
    private final Class<? extends CachePersistenceReduction> persistenceReductionClass;
    private String resultMessage;

    public PersistenceReductionProcess(String path, Class<? extends CachePersistenceReduction> persistenceReductionClass) {
        this.path = path;
        this.persistenceReductionClass = persistenceReductionClass;
    }

    public String getPath() {
        return this.path;
    }

    public Class<? extends CachePersistenceReduction> getPersistenceReductionClass() {
        return this.persistenceReductionClass;
    }

    public String getResultMessage() {
        return this.resultMessage;
    }

    @PostConstruct
    public void reductionUsePath() {
        CachePersistenceReduction reduction;
        if (StringUtils.isBlank((CharSequence)this.path) || this.persistenceReductionClass == null) {
            this.resultMessage = "reductionPath or persistenceReductionClass is null";
            return;
        }
        try {
            reduction = (CachePersistenceReduction)ReflectUtils.newInstance(this.persistenceReductionClass, (Object[])new Object[0]);
        }
        catch (Exception e) {
            this.resultMessage = "persistenceReductionClass newInstance  for default Constructor filed";
            return;
        }
        reduction.reductionUsePath(this.path);
        this.resultMessage = "process";
    }
}

