/*
 * Decompiled with CFR 0.152.
 */
package top.osjf.assembly.cache.autoconfigure;

import java.io.PrintStream;
import org.springframework.boot.ansi.AnsiColor;
import org.springframework.boot.ansi.AnsiOutput;
import org.springframework.boot.ansi.AnsiStyle;
import org.springframework.core.env.Environment;
import top.osjf.assembly.cache.CacheVersion;
import top.osjf.assembly.cache.autoconfigure.StartUpBanner;
import top.osjf.assembly.util.annotation.CanNull;

public final class StartUpBannerExecutor {
    private StartUpBannerExecutor() {
    }

    public static void printBanner(@CanNull Environment environment, StartUpBanner banner, Class<?> sourceClass, PrintStream printStream) {
        printStream.println(banner.getBanner());
        String version = CacheVersion.getVersion(sourceClass);
        version = version != null ? " (v" + version + ")" : "";
        StringBuilder padding = new StringBuilder();
        while (padding.length() < 42 - (version.length() + banner.getLeftSign().length())) {
            padding.append(" ");
        }
        printStream.println(AnsiOutput.toString((Object[])new Object[]{AnsiColor.GREEN, banner.getLeftSign(), AnsiColor.DEFAULT, padding.toString(), AnsiStyle.FAINT, version}));
        printStream.println();
    }
}

