package com.wu.framework.inner.lazy.database.expand.database.persistence;

/**
 * describe : DDL 语言
 * 数据定义语言DDL用来创建数据库中的各种对象-----表、视图、
 * 索引、同义词、聚簇等如：
 * CREATE TABLE/VIEW/INDEX/SYN/CLUSTER
 * |         |          |          |          |
 * 表    视图    索引   同义词    簇
 * <p>
 * DDL操作是隐性提交的！不能rollback
 *
 * @author : Jia wei Wu
 * @version 1.0
 * @date : 2022/4/23 22:58
 */
public interface LazyDDLOperation {

    /**
     * describe 创建表
     *
     * @param tableClazz 表对应的实体
     * @return
     * @throws
     * @author Jia wei Wu
     * @date 2022/5/1 21:25
     **/
    void createTable(Class tableClazz);

    /**
     * describe 创建视图
     *
     * @param tableClazz 表对应的实体
     * @return
     * @throws
     * @author Jia wei Wu
     * @date 2022/5/1 21:25
     **/
    void createView(Class tableClazz);

    /**
     * describe 创建索引
     *
     * @param tableClazz 表对应的实体
     * @return
     * @throws
     * @author Jia wei Wu
     * @date 2022/5/1 21:25
     **/
    void createIndex(Class tableClazz);


}
