package com.wu.framework.inner.lazy.database.expand.database.persistence.factory;

import com.wu.framework.inner.lazy.config.prop.LazyDataSourceProperties;
import com.wu.framework.inner.lazy.database.expand.database.persistence.LazyOperation;
import com.wu.framework.inner.lazy.database.expand.database.persistence.stream.lambda.LazyLambdaStream;

/**
 * describe : LazyLambdaStream 工厂
 *
 * @author : Jia wei Wu
 * @version 1.0
 * @date : 2022/6/25 15:31
 */
public final class LazyLambdaStreamFactory {


    /**
     * 创建 LazyLambdaStream 对象
     *
     * @param lazyDataSourceProperties
     * @return
     */
    public static LazyLambdaStream createLazyLambdaStream(LazyDataSourceProperties lazyDataSourceProperties) {

        LazyOperation lazyOperation = LazyOperationProxyFactory.createLazyOperation(lazyDataSourceProperties);
        LazyLambdaStream lazyLambdaStream = new LazyLambdaStream(lazyOperation);

        return lazyLambdaStream;
    }

    /**
     * 创建 LazyLambdaStream 对象
     *
     * @param url      数据库地址
     * @param username 用户名称
     * @param password 用户密码
     * @return 自动填充数据对象
     * @return
     */
    public static LazyLambdaStream createLazyLambdaStream(String url, String username, String password) {
        LazyDataSourceProperties lazyDataSourceProperties = new LazyDataSourceProperties();
        lazyDataSourceProperties.setUrl(url);
        lazyDataSourceProperties.setUsername(username);
        lazyDataSourceProperties.setPassword(password);
        return createLazyLambdaStream(lazyDataSourceProperties);
    }

    /**
     * 创建 LazyLambdaStream 对象
     *
     * @param host     数据库IP
     * @param port     数据库端口
     * @param username 用户名称
     * @param password 用户密码
     * @return 自动填充数据对象
     * @return
     */
    public static LazyLambdaStream createLazyLambdaStream(String host, int port, String schema, String username, String password) {
        String urlFormat = "jdbc:mysql://%s:%s/%s?useUnicode=true&characterEncoding=utf-8&useSSL=true&allowMultiQueries=true&serverTimezone=Asia/Shanghai";
        String url = String.format(urlFormat, host, port, schema);

        return createLazyLambdaStream(url, username, password);
    }

}
