package com.wu.framework.inner.lazy.database.smart.database.persistence;

import com.wu.framework.inner.layer.data.NormalUsedString;
import com.wu.framework.inner.lazy.database.domain.LazyColumn;
import com.wu.framework.inner.lazy.database.domain.LazyTableInfo;
import com.wu.framework.inner.lazy.database.expand.database.persistence.LazyOperation;
import com.wu.framework.inner.lazy.database.expand.database.persistence.stream.lambda.LazyLambdaStream;
import com.wu.framework.inner.lazy.database.expand.database.persistence.stream.wrapper.LazyWrappers;
import com.wu.framework.inner.lazy.persistence.conf.AbstractLazyTableFieldEndpoint;
import com.wu.framework.inner.lazy.persistence.conf.LazyTableEndpoint;
import com.wu.framework.inner.lazy.persistence.conf.LazyTableFieldEndpoint;
import com.wu.framework.inner.lazy.persistence.util.LazyTableUtil;
import lombok.extern.slf4j.Slf4j;
import org.springframework.util.ObjectUtils;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;

/**
 * 完善表结构
 */
@Deprecated
@Slf4j
public class LazyOperationAutoPerfectStructure {

    private final LazyLambdaStream lambdaStream;
    private final LazyOperation lazyOperation;

    public LazyOperationAutoPerfectStructure(LazyLambdaStream lambdaStream, LazyOperation lazyOperation) {
        this.lambdaStream = lambdaStream;
        this.lazyOperation = lazyOperation;
    }

    /**
     * 完善表结构
     *
     * @param entityClass
     * @return
     */
    public void perfectTable(Class entityClass) {
        LazyTableEndpoint lazyTableEndpoint = LazyTableUtil.analyzeLazyTable(entityClass);
        final Collection<LazyTableInfo> collection = lambdaStream.of(LazyTableInfo.class).selectList(LazyWrappers.<LazyTableInfo>lambdaWrapper().
                eqIgnoreEmpty(LazyTableInfo::getTableSchema, lazyTableEndpoint.getSchema()).
                eqIgnoreEmpty(LazyTableInfo::getTableName, lazyTableEndpoint.getTableName()));
        if (ObjectUtils.isEmpty(collection)) {
            // 创建表
            String createTableSQL = lazyTableEndpoint.creatTableSQL();
            for (String sql : createTableSQL.split(NormalUsedString.SEMICOLON)) {
                lazyOperation.executeSQL(sql, Integer.class);
            }
            log.info("create table {} success", lazyTableEndpoint.getTableName());
        } else {
            // 更新表数据
            final Collection<LazyColumn> lazyColumnCollection = lambdaStream.of(LazyColumn.class).selectList(LazyWrappers.<LazyColumn>lambdaWrapper().
                    eqIgnoreEmpty(LazyColumn::getTableSchema, lazyTableEndpoint.getSchema()).
                    eqIgnoreEmpty(LazyColumn::getTableName, lazyTableEndpoint.getTableName()));

            List<LazyTableFieldEndpoint> currentColumnNameList = new ArrayList<>();

            for (LazyColumn lazyColumn : lazyColumnCollection) {
                LazyTableFieldEndpoint convertedField = AbstractLazyTableFieldEndpoint.getInstance();
                convertedField.setColumnName(lazyColumn.getColumnName());
                convertedField.setColumnType(lazyColumn.getColumnType());
                currentColumnNameList.add(convertedField);
            }
            String alterTableSQL = lazyTableEndpoint.alterTableSQL(currentColumnNameList);
            if (!ObjectUtils.isEmpty(alterTableSQL)) {
                final List<Integer> integers = lazyOperation.executeSQL(alterTableSQL, Integer.class);
            }
        }
    }
}
