package com.wu.framework.inner.lazy.database.config;

import com.wu.framework.inner.lazy.config.LazyOperationConfig;
import com.wu.framework.inner.lazy.database.expand.database.persistence.stream.lambda.LazyLambdaStream;
import com.wu.framework.inner.lazy.database.smart.database.SmartLazyOperationAutoStuffed;
import com.wu.framework.inner.lazy.database.smart.database.persistence.LazyOperationSmartAutoStuffed;
import lombok.extern.slf4j.Slf4j;
import org.springframework.boot.autoconfigure.condition.ConditionalOnBean;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.context.annotation.Bean;

import javax.sql.DataSource;

/**
 * describe :
 *
 * @author : Jia wei Wu
 * @version 1.0
 * @date : 2022/6/26 01:57
 */
@Slf4j
@ConditionalOnBean(value = DataSource.class)
public class LazyOperationBeanAutoConfiguration {

    @Bean
    @ConditionalOnMissingBean(SmartLazyOperationAutoStuffed.class)
    public SmartLazyOperationAutoStuffed autoStuffed(LazyOperationConfig operationConfig, LazyLambdaStream lazyLambdaStream) {
        return new LazyOperationSmartAutoStuffed(operationConfig, lazyLambdaStream);
    }
}

