package com.wu.framework.inner.lazy.database.expand.database.persistence.config;


import com.wu.framework.inner.database.dynamic.LazyDynamicAdapter;
import com.wu.framework.inner.lazy.config.LazyOperationConfig;
import com.wu.framework.inner.lazy.database.expand.database.persistence.LazyBaseDDLOperation;
import com.wu.framework.inner.lazy.database.expand.database.persistence.LazyBaseDQLOperation;
import com.wu.framework.inner.lazy.database.expand.database.persistence.LazyOperation;
import com.wu.framework.inner.lazy.database.expand.database.persistence.cure.CureAdapter;
import com.wu.framework.inner.lazy.database.expand.database.persistence.factory.config.LazyBeanPostProcessor;
import com.wu.framework.inner.lazy.database.expand.database.persistence.method.LazyOperationMethod;
import com.wu.framework.inner.lazy.database.expand.database.persistence.method.ddl.LazyDDLOperationMethod;
import com.wu.framework.inner.lazy.database.expand.database.persistence.method.dql.LazyDQLOperationMethod;
import com.wu.framework.inner.lazy.database.expand.database.persistence.proxy.LazyDDLOperationProxy;
import com.wu.framework.inner.lazy.database.expand.database.persistence.proxy.LazyDQLOperationProxy;
import com.wu.framework.inner.lazy.database.expand.database.persistence.proxy.LazyOperationProxy;
import com.wu.framework.inner.lazy.database.expand.database.persistence.stream.lambda.LazyLambdaStream;
import com.wu.framework.inner.lazy.database.smart.database.persistence.PerfectLazyOperation;
import org.springframework.beans.factory.config.BeanDefinition;
import org.springframework.boot.autoconfigure.condition.ConditionalOnBean;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Role;

import javax.sql.DataSource;
import java.lang.reflect.Proxy;
import java.util.List;
import java.util.Map;

@Role(BeanDefinition.ROLE_INFRASTRUCTURE)
public class LazyOperationProxyBeanAutoConfiguration {


    /**
     * 动态数据适配Lazy 适配器
     *
     * @return
     */
    @ConditionalOnBean(value = DataSource.class)
    @ConditionalOnMissingBean(value = LazyDynamicAdapter.class)
    @Bean
    @Role(BeanDefinition.ROLE_INFRASTRUCTURE)
    public LazyDynamicAdapter lazyDynamicAdapter(Map<String, DataSource> dataSourceMap) {
        return new LazyDynamicAdapter(dataSourceMap);
    }


    /**
     * @param
     * @return describe 延迟操作代理Proxy
     * @author Jia wei Wu
     * @date 2021/4/17 7:34 下午
     **/
    @ConditionalOnBean(value = {DataSource.class, LazyDynamicAdapter.class})
    @ConditionalOnMissingBean(value = LazyOperationProxy.class)
    @Bean
    @Role(BeanDefinition.ROLE_INFRASTRUCTURE)
    public LazyOperationProxy lazyOperationProxy(List<LazyOperationMethod> lazyOperationMethods, LazyDynamicAdapter lazyDynamicAdapter, CureAdapter cureAdapter) {
        return new LazyOperationProxy(lazyOperationMethods, lazyDynamicAdapter, cureAdapter);
    }

    /**
     * @param
     * @return describe 延迟操作代理
     * @author Jia wei Wu
     * @date 2021/4/17 7:34 下午
     **/
    @ConditionalOnBean(value = {DataSource.class, LazyOperationProxy.class})
    @ConditionalOnMissingBean(value = LazyOperation.class)
    @Bean
    @Role(BeanDefinition.ROLE_INFRASTRUCTURE)
    public LazyOperation lazyOperation(LazyOperationProxy lazyOperationProxy) {
        return (LazyOperation) Proxy.newProxyInstance(LazyOperation.class.getClassLoader(), new Class[]{LazyOperation.class}, lazyOperationProxy);
    }


    /**
     * @param
     * @return describe 延迟操作代理DDL Proxy
     * @author Jia wei Wu
     * @date 2021/4/17 7:34 下午
     **/
    @ConditionalOnBean(value = {DataSource.class, LazyDynamicAdapter.class})
    @ConditionalOnMissingBean(value = LazyDDLOperationProxy.class)
    @Bean
    @Role(BeanDefinition.ROLE_INFRASTRUCTURE)
    public LazyDDLOperationProxy lazyDDLOperationProxy(List<LazyDDLOperationMethod> lazyDDLOperationMethodList, LazyDynamicAdapter lazyDynamicAdapter) {
        return new LazyDDLOperationProxy(lazyDDLOperationMethodList, lazyDynamicAdapter);
    }

    /**
     * @param
     * @return describe 延迟操作DDL代理
     * @author Jia wei Wu
     * @date 2021/4/17 7:34 下午
     **/
    @ConditionalOnBean(value = {DataSource.class, LazyDDLOperationProxy.class})
    @Bean
    @Role(BeanDefinition.ROLE_INFRASTRUCTURE)
    public LazyBaseDDLOperation lazyBaseDDLOperation(LazyDDLOperationProxy lazyDDLOperationProxy) {
        return (LazyBaseDDLOperation) Proxy.newProxyInstance(LazyBaseDDLOperation.class.getClassLoader(), new Class[]{LazyBaseDDLOperation.class}, lazyDDLOperationProxy);
    }


    /**
     * @param
     * @return describe 延迟操作代理DQLProxy
     * @author Jia wei Wu
     * @date 2021/4/17 7:34 下午
     **/
    @ConditionalOnBean(value = {DataSource.class, LazyDynamicAdapter.class})
    @ConditionalOnMissingBean(value = LazyDQLOperationProxy.class)
    @Bean
    @Role(BeanDefinition.ROLE_INFRASTRUCTURE)
    public LazyDQLOperationProxy lazyDQLOperationProxy(List<LazyDQLOperationMethod> lazyDQLOperationMethods, LazyDynamicAdapter lazyDynamicAdapter) {
        return new LazyDQLOperationProxy(lazyDQLOperationMethods, lazyDynamicAdapter);
    }

    /**
     * @param
     * @return describe 延迟操作DDL代理
     * @author Jia wei Wu
     * @date 2021/4/17 7:34 下午
     **/
    @ConditionalOnBean(value = {DataSource.class, LazyDQLOperationProxy.class})
    @Bean
    @Role(BeanDefinition.ROLE_INFRASTRUCTURE)
    public LazyBaseDQLOperation lazyBaseDQLOperation(LazyDQLOperationProxy lazyDQLOperationProxy) {
        return (LazyBaseDQLOperation) Proxy.newProxyInstance(LazyBaseDQLOperation.class.getClassLoader(), new Class[]{LazyBaseDQLOperation.class}, lazyDQLOperationProxy);
    }


    /**
     * 完美处理方式
     *
     * @param exportDataConfiguration
     * @param lazyLambdaStream
     * @return
     */
    @ConditionalOnBean(value = {DataSource.class, LazyOperationProxy.class})
    @ConditionalOnMissingBean(value = PerfectLazyOperation.class)
    @Bean
    @Role(BeanDefinition.ROLE_INFRASTRUCTURE)
    public PerfectLazyOperation perfectLazyOperation(ExportDataConfiguration exportDataConfiguration, LazyLambdaStream lazyLambdaStream) {
        return new PerfectLazyOperation(exportDataConfiguration, lazyLambdaStream);
    }


    /**
     * LazyScan 扫描处理器
     *
     * @param operation
     * @param operationConfig
     * @return
     */
    @ConditionalOnBean(value = {DataSource.class, LazyOperation.class})
    @ConditionalOnMissingBean(value = LazyBeanPostProcessor.class)
    @Bean
    @Role(BeanDefinition.ROLE_INFRASTRUCTURE)
    public LazyBeanPostProcessor lazyBeanPostProcessor(LazyOperation operation, LazyOperationConfig operationConfig) {
        return new LazyBeanPostProcessor(operation, operationConfig);
    }


//    /**
//    * describe 完美的惰性操作代理
//    * @param
//    * @return
//    * @author Jia wei Wu
//    * @date 2021/4/17 7:34 下午
//    **/
//    @Bean
//    public PerfectLazyOperation perfectLazyOperationProxy(PerfectLazyOperationProxy perfectLazyOperationProxy) {
//        return (PerfectLazyOperation) Proxy.newProxyInstance(PerfectLazyOperation.class.getClassLoader(), new Class[]{PerfectLazyOperation.class}, perfectLazyOperationProxy);
//    }


}

