package com.wu.framework.inner.lazy.database.expand.database.persistence.cure;

import java.sql.SQLException;

/**
 * description 抽象治愈
 *
 * @author Jia wei Wu
 * @date 2023/01/15 19:01
 */
public abstract class AbstractCure implements Cure {


    /**
     * 判断是否支持 SQLException 异常治愈
     *
     * @param sqlException
     */
    public abstract boolean supportsSQLException(SQLException sqlException);

    /**
     * 判断当前能否治愈此异常
     *
     * @param throwable 异常信息
     * @return
     */
    @Override
    public boolean supports(Throwable throwable) {
        //Table 'acw3333449900012222.api' doesn't exist
        if (throwable.getCause() instanceof SQLException) {
            SQLException sqlException = (SQLException) throwable.getCause();
            return supportsSQLException(sqlException);
        }
        return false;
    }
}
