package com.wu.framework.inner.lazy.database.expand.database.persistence.cure.lazy;

import com.wu.framework.inner.layer.stereotype.proxy.ProxyRetryInvocationHandler;
import com.wu.framework.inner.lazy.database.expand.database.persistence.LazyBaseDDLOperation;
import com.wu.framework.inner.lazy.database.expand.database.persistence.LazyBaseDQLOperation;
import com.wu.framework.inner.lazy.database.expand.database.persistence.cure.AbstractCure;
import com.wu.framework.inner.lazy.database.expand.database.persistence.cure.Cure;
import com.wu.framework.inner.lazy.database.expand.database.persistence.cure.TableCure;
import com.wu.framework.inner.lazy.database.util.SqlUtils;
import com.wu.framework.inner.lazy.persistence.conf.LazyDatabaseJsonMessage;
import com.wu.framework.inner.lazy.persistence.conf.LazyTableEndpoint;
import com.wu.framework.inner.lazy.persistence.util.LazyTableUtil;
import org.springframework.util.ObjectUtils;

import java.lang.reflect.Method;
import java.sql.SQLException;
import java.util.List;
import java.util.concurrent.ConcurrentMap;
import java.util.stream.Collectors;

/**
 * description 表治愈
 *
 * @author Jia wei Wu
 * @date 2023/01/11 17:15
 */
public class LazyTableCure extends AbstractCure implements TableCure, Cure {

    private final LazyBaseDDLOperation lazyBaseDDLOperation;
    private final LazyBaseDQLOperation lazyBaseDQLOperation;

    public LazyTableCure(LazyBaseDDLOperation lazyBaseDDLOperation, LazyBaseDQLOperation lazyBaseDQLOperation) {
        this.lazyBaseDDLOperation = lazyBaseDDLOperation;
        this.lazyBaseDQLOperation = lazyBaseDQLOperation;
    }

    /**
     * 判断是否支持 SQLException 异常治愈
     *
     * @param sqlException
     */
    @Override
    public boolean supportsSQLException(SQLException sqlException) {
        String sqlState = sqlException.getSQLState();
        return "42S02".equals(sqlState);
    }

    /**
     * 治愈
     *
     * @param invocationHandler
     * @param proxy
     * @param method
     * @param args
     * @param retryTime
     * @param throwable
     */
    @Override
    public void cure(ProxyRetryInvocationHandler invocationHandler, Object proxy, Method method, Object[] args, int retryTime, Throwable throwable) throws Throwable {

        String message = throwable.getMessage();

        List<String> tables = SqlUtils.tablesInSql(message);
        // 解析sql 中的表、字段
        if (ObjectUtils.isEmpty(tables)) {
            return;
        }
        // 创建表
        ConcurrentMap<Class<?>, LazyTableEndpoint> tableCache = LazyTableUtil.getTableCache();
        List<Class> cacheClazz = tableCache.values().stream().filter(lazyTableEndpoint -> tables.contains(lazyTableEndpoint.getTableName()))
                .map(LazyTableEndpoint::getClazz).collect(Collectors.toList());

        LazyDatabaseJsonMessage.localCacheEntityClass.removeAll(cacheClazz);
        lazyBaseDDLOperation.createTable(cacheClazz.toArray(new Class[0]));
        //
    }


}
