package com.wu.framework.inner.lazy.database.expand.database.persistence.method;

import com.wu.framework.inner.lazy.config.LazyOperationConfig;
import com.wu.framework.inner.lazy.database.expand.database.persistence.method.ddl.*;
import com.wu.framework.inner.lazy.database.expand.database.persistence.method.dml.*;
import com.wu.framework.inner.lazy.database.expand.database.persistence.method.dql.*;
import org.springframework.beans.factory.config.BeanDefinition;
import org.springframework.boot.autoconfigure.condition.ConditionalOnBean;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.context.annotation.Role;

import javax.sql.DataSource;

/**
 * @author : Jiawei Wu
 * @version 1.0
 * describe :
 * @date : 2021/1/24 5:19 下午
 */
@Role(BeanDefinition.ROLE_INFRASTRUCTURE)
@Configuration
public class LazyMethodConfig {

    /**
     * describe 创建表结构
     *
     * @author Jia wei Wu
     * @date 2022/7/15 22:38
     **/
    @ConditionalOnBean(value = DataSource.class)
    @ConditionalOnMissingBean(value = LazyOperationMethodCreateTable.class)
    @Bean
    @Role(BeanDefinition.ROLE_INFRASTRUCTURE)
    public LazyOperationMethodCreateTable lazyOperationMethodCreateTable() {
        return new LazyOperationMethodCreateTable();
    }

    /**
     * describe 根据ID更新  自定义数据库持久层操作方法按ID删除
     *
     * @param lazyOperationConfig 操作配置
     * @author Jia wei Wu
     * @date 2022/7/15 22:38
     **/
    @ConditionalOnBean(value = DataSource.class)
    @ConditionalOnMissingBean(value = LazyOperationMethodDeleteById.class)
    @Bean
    @Role(BeanDefinition.ROLE_INFRASTRUCTURE)
    public LazyOperationMethodDeleteById lazyOperationMethodDeleteById(LazyOperationConfig lazyOperationConfig) {
        return new LazyOperationMethodDeleteById(lazyOperationConfig);
    }

    /**
     * describe 根据ID更新  自定义数据库持久层操作方法I按ID列表删除
     *
     * @param lazyOperationConfig 操作配置
     * @author Jia wei Wu
     * @date 2022/7/15 22:38
     **/
    @ConditionalOnBean(value = DataSource.class)
    @ConditionalOnMissingBean(value = LazyOperationMethodDeleteByIdList.class)
    @Bean
    @Role(BeanDefinition.ROLE_INFRASTRUCTURE)
    public LazyOperationMethodDeleteByIdList lazyOperationMethodDeleteByIdList(LazyOperationConfig lazyOperationConfig) {
        return new LazyOperationMethodDeleteByIdList(lazyOperationConfig);
    }

    /**
     * describe 根据ID更新  自定义数据库持久层操作方法I按ID列表删除
     *
     * @author Jia wei Wu
     * @date 2022/7/15 22:38
     **/
    @ConditionalOnBean(value = DataSource.class)
    @ConditionalOnMissingBean(value = LazyOperationMethodExecute.class)
    @Bean
    @Role(BeanDefinition.ROLE_INFRASTRUCTURE)
    public LazyOperationMethodExecute lazyOperationMethodExecute() {
        return new LazyOperationMethodExecute();
    }

    /**
     * describe 执行返回一条数据
     *
     * @author Jia wei Wu
     * @date 2022/7/15 22:38
     **/
    @ConditionalOnBean(value = DataSource.class)
    @ConditionalOnMissingBean(value = LazyOperationMethodExecuteOne.class)
    @Bean
    @Role(BeanDefinition.ROLE_INFRASTRUCTURE)
    public LazyOperationMethodExecuteOne lazyOperationMethodExecuteOne() {
        return new LazyOperationMethodExecuteOne();
    }

    /**
     * describe 自定义数据库持久层操作方法执行SQL
     *
     * @param lazyOperationConfig 操作配置
     * @author Jia wei Wu
     * @date 2022/7/15 22:38
     **/
    @ConditionalOnBean(value = DataSource.class)
    @ConditionalOnMissingBean(value = LazyOperationMethodExecuteSQL.class)
    @Bean
    @Role(BeanDefinition.ROLE_INFRASTRUCTURE)
    public LazyOperationMethodExecuteSQL lazyOperationMethodExecuteSQL(LazyOperationConfig lazyOperationConfig) {
        return new LazyOperationMethodExecuteSQL(lazyOperationConfig);
    }

    /**
     * describe 执行SQL  自定义数据库持久层操作方法对Bean执行SQL
     *
     * @param lazyOperationConfig 操作配置
     * @author Jia wei Wu
     * @date 2022/7/15 22:38
     **/
    @ConditionalOnBean(value = DataSource.class)
    @ConditionalOnMissingBean(value = LazyOperationMethodExecuteSQLForBean.class)
    @Bean
    @Role(BeanDefinition.ROLE_INFRASTRUCTURE)
    public LazyOperationMethodExecuteSQLForBean lazyOperationMethodExecuteSQLForBean(LazyOperationConfig lazyOperationConfig) {
        return new LazyOperationMethodExecuteSQLForBean(lazyOperationConfig);
    }

    /**
     * describe 自定义数据库持久层操作方法插入
     *
     * @param lazyOperationConfig 操作配置
     * @author Jia wei Wu
     * @date 2022/7/15 22:38
     **/
    @ConditionalOnBean(value = DataSource.class)
    @ConditionalOnMissingBean(value = LazyOperationMethodInsert.class)
    @Bean
    @Role(BeanDefinition.ROLE_INFRASTRUCTURE)
    public LazyOperationMethodInsert lazyOperationMethodInsert(LazyOperationConfig lazyOperationConfig) {
        return new LazyOperationMethodInsert(lazyOperationConfig);
    }

    /**
     * describe 分页查询
     *
     * @param lazyOperationConfig 操作配置
     * @author Jia wei Wu
     * @date 2022/7/15 22:38
     **/
    @ConditionalOnBean(value = DataSource.class)
    @ConditionalOnMissingBean(value = LazyOperationMethodPage.class)
    @Bean
    @Role(BeanDefinition.ROLE_INFRASTRUCTURE)
    public LazyOperationMethodPage lazyOperationMethodPage(LazyOperationConfig lazyOperationConfig) {
        return new LazyOperationMethodPage(lazyOperationConfig);
    }

    /**
     * describe 完善表
     *
     * @param lazyOperationConfig 操作配置
     * @author Jia wei Wu
     * @date 2022/7/15 22:38
     **/
    @ConditionalOnBean(value = DataSource.class)
    @ConditionalOnMissingBean(value = LazyOperationMethodPerfect.class)
    @Bean
    @Role(BeanDefinition.ROLE_INFRASTRUCTURE)
    public LazyOperationMethodPerfect lazyOperationMethodPerfect(LazyOperationConfig lazyOperationConfig) {
        return new LazyOperationMethodPerfect(lazyOperationConfig);
    }

    /**
     * describe 根据ID更新  自定义数据库持久层操作方法我选择列表
     *
     * @param lazyOperationConfig 操作配置
     * @author Jia wei Wu
     * @date 2022/7/15 22:38
     **/
    @ConditionalOnBean(value = DataSource.class)
    @ConditionalOnMissingBean(value = LazyOperationMethodSelectList.class)
    @Bean
    @Role(BeanDefinition.ROLE_INFRASTRUCTURE)
    public LazyOperationMethodSelectList lazyOperationMethodSelectList(LazyOperationConfig lazyOperationConfig) {
        return new LazyOperationMethodSelectList(lazyOperationConfig);
    }

    /**
     * describe 根据ID更新  自定义数据库持久层操作方法我选择一种
     *
     * @param lazyOperationConfig 操作配置
     * @author Jia wei Wu
     * @date 2022/7/15 22:38
     **/
    @ConditionalOnBean(value = DataSource.class)
    @ConditionalOnMissingBean(value = LazyOperationMethodSelectOne.class)
    @Bean
    @Role(BeanDefinition.ROLE_INFRASTRUCTURE)
    public LazyOperationMethodSelectOne lazyOperationMethodSelectOne(LazyOperationConfig lazyOperationConfig) {
        return new LazyOperationMethodSelectOne(lazyOperationConfig);
    }

    /**
     * describe 灵活更新 去除null的字段、创建表
     *
     * @param lazyOperationConfig 操作配置
     * @author Jia wei Wu
     * @date 2022/7/15 22:38
     **/
    @ConditionalOnProperty(prefix = "spring.datasource", value = "driver-class-name", havingValue = "com.mysql.cj.jdbc.Driver")
    @ConditionalOnMissingBean(value = LazyOperationMethodSmartUpsert.class)
    @Bean
    @Role(BeanDefinition.ROLE_INFRASTRUCTURE)
    public LazyOperationMethodSmartUpsert lazyOperationMethodSmartUpsert(LazyOperationConfig lazyOperationConfig) {
        return new LazyOperationMethodSmartUpsert(lazyOperationConfig);
    }

    /**
     * describe 根据ID更新 自定义数据库持久层操作方法I按ID更新全部
     *
     * @param lazyOperationConfig 操作配置
     * @author Jia wei Wu
     * @date 2022/7/15 22:38
     **/
    @ConditionalOnBean(value = DataSource.class)
    @ConditionalOnMissingBean(value = LazyOperationMethodUpdateAllById.class)
    @Bean
    @Role(BeanDefinition.ROLE_INFRASTRUCTURE)
    public LazyOperationMethodUpdateAllById lazyOperationMethodUpdateAllById(LazyOperationConfig lazyOperationConfig) {
        return new LazyOperationMethodUpdateAllById(lazyOperationConfig);
    }

    /**
     * describe 根据ID更新 自定义数据库持久层操作方法I按ID更新全部
     *
     * @param lazyOperationConfig 操作配置
     * @author Jia wei Wu
     * @date 2022/7/15 22:38
     **/
    @ConditionalOnBean(value = DataSource.class)
    @ConditionalOnMissingBean(value = LazyOperationMethodUpdateById.class)
    @Bean
    @Role(BeanDefinition.ROLE_INFRASTRUCTURE)
    public LazyOperationMethodUpdateById lazyOperationMethodUpdateById(LazyOperationConfig lazyOperationConfig) {
        return new LazyOperationMethodUpdateById(lazyOperationConfig);
    }

    /**
     * describe 更新表
     *
     * @author Jia wei Wu
     * @date 2022/7/15 22:38
     **/
    @ConditionalOnBean(value = DataSource.class)
    @ConditionalOnMissingBean(value = LazyOperationMethodUpdateTable.class)
    @Bean
    @Role(BeanDefinition.ROLE_INFRASTRUCTURE)
    public LazyOperationMethodUpdateTable lazyOperationMethodUpdateTable() {
        return new LazyOperationMethodUpdateTable();
    }

    /**
     * describe upsert 操作
     *
     * @param lazyOperationConfig 操作配置
     * @author Jia wei Wu
     * @date 2022/7/15 22:38
     **/
    @ConditionalOnProperty(prefix = "spring.datasource", value = "driver-class-name", havingValue = "com.mysql.cj.jdbc.Driver")
    @ConditionalOnMissingBean(value = LazyOperationMethodUpsert.class)
    @Bean
    @Role(BeanDefinition.ROLE_INFRASTRUCTURE)
    public LazyOperationMethodUpsert lazyOperationMethodUpsert(LazyOperationConfig lazyOperationConfig) {
        return new LazyOperationMethodUpsert(lazyOperationConfig);
    }

    /**
     * describe 去除null的字段
     *
     * @param lazyOperationConfig 操作配置
     * @author Jia wei Wu
     * @date 2022/7/15 22:38
     **/
    @ConditionalOnProperty(prefix = "spring.datasource", value = "driver-class-name", havingValue = "com.mysql.cj.jdbc.Driver")
    @ConditionalOnMissingBean(value = LazyOperationMethodUpsertRemoveNull.class)
    @Bean
    @Role(BeanDefinition.ROLE_INFRASTRUCTURE)
    public LazyOperationMethodUpsertRemoveNull lazyOperationMethodUpsertRemoveNull(LazyOperationConfig lazyOperationConfig) {
        return new LazyOperationMethodUpsertRemoveNull(lazyOperationConfig);
    }

    /**
     * describe 执行sql脚本
     *
     * @param lazyOperationConfig 操作配置
     * @author Jia wei Wu
     * @date 2022/7/16 23:07
     **/
    @ConditionalOnBean(value = DataSource.class)
    @ConditionalOnMissingBean(value = LazyOperationMethodScriptRunner.class)
    @Bean
    @Role(BeanDefinition.ROLE_INFRASTRUCTURE)
    public LazyOperationMethodScriptRunner lazyOperationMethodScriptRunner(LazyOperationConfig lazyOperationConfig) {
        return new LazyOperationMethodScriptRunner(lazyOperationConfig);
    }

    /**
     * describe 执行 字符串 sql脚本
     *
     * @param lazyOperationConfig 操作配置
     * @author Jia wei Wu
     * @date 2022/7/16 23:07
     **/
    @ConditionalOnBean(value = DataSource.class)
    @ConditionalOnMissingBean(value = LazyOperationMethodStringScriptRunner.class)
    @Bean
    @Role(BeanDefinition.ROLE_INFRASTRUCTURE)
    public LazyOperationMethodStringScriptRunner lazyOperationMethodStringScriptRunner(LazyOperationConfig lazyOperationConfig) {
        return new LazyOperationMethodStringScriptRunner(lazyOperationConfig);
    }
}
