package com.wu.framework.inner.lazy.database.expand.database.persistence.method.ddl;

import com.wu.framework.inner.lazy.config.LazyOperationConfig;
import com.wu.framework.inner.lazy.config.enums.DDLAuto;
import com.wu.framework.inner.lazy.database.expand.database.persistence.domain.PersistenceRepository;
import com.wu.framework.inner.lazy.database.expand.database.persistence.domain.PersistenceRepositoryFactory;
import com.wu.framework.inner.lazy.persistence.conf.LazyTableEndpoint;
import com.wu.framework.inner.lazy.persistence.util.LazyTableUtil;
import lombok.extern.slf4j.Slf4j;
import org.springframework.beans.factory.config.BeanDefinition;
import org.springframework.context.annotation.Role;

import java.sql.Connection;
import java.sql.SQLException;

/**
 * describe: 完善表
 *
 * @author : Jia wei Wu
 * @version : 1.0
 * @date : 2022/1/2 5:03 下午
 */
@Role(BeanDefinition.ROLE_INFRASTRUCTURE)
@Slf4j
public class LazyOperationMethodPerfect extends AbstractLazyDDLOperationMethod {
    private final LazyOperationConfig operationConfig;

    public LazyOperationMethodPerfect(LazyOperationConfig operationConfig) {
        this.operationConfig = operationConfig;
    }


    /**
     * @param params
     * @return description 通过参数获取持久性存储库对象
     * @author Jia wei Wu
     * @date 2021/4/17 3:38 下午
     **/
    @Override
    public PersistenceRepository analyzePersistenceRepository(Object params) throws Exception {

        PersistenceRepository persistenceRepository = PersistenceRepositoryFactory.create(operationConfig);

        return persistenceRepository;
    }

    /**
     * description 执行SQL 语句
     *
     * @param connection
     * @param sourceParams
     * @return
     * @params
     * @author Jia wei Wu
     * @date 2020/11/22 上午11:02
     */
    @Override
    public Object execute(Connection connection, Object[] sourceParams) throws Exception {
        final Object param = sourceParams[0];
        if (param instanceof Object[]) {
            Object[] objects = (Object[]) param;
            for (Object o : objects) {
                if (null == o) {
                    continue;
                }
                Class<?> paramClass = o.getClass();
                if (Class.class.isAssignableFrom(paramClass)) {
                    final Class<?> entityClass = (Class<?>) o;
                    perfect(entityClass,connection);
                } else if (LazyTableEndpoint.class.isAssignableFrom(paramClass)) {
                    LazyTableEndpoint lazyTableEndpoint = (LazyTableEndpoint) o;
                    perfect(connection, lazyTableEndpoint, DDLAuto.PERFECT);
                }

            }
        } else {
            if (null == param) {
                return false;
            }
            Class<?> paramClass = param.getClass();
            if (Class.class.isAssignableFrom(paramClass)) {
                final Class<?> entityClass = (Class<?>) param;
                perfect(entityClass,connection);
            } else if (LazyTableEndpoint.class.isAssignableFrom(paramClass)) {
                LazyTableEndpoint lazyTableEndpoint = (LazyTableEndpoint) param;
                perfect(connection, lazyTableEndpoint, DDLAuto.PERFECT);
            }
        }
        return true;
    }

    protected void perfect(Class entityClass, Connection connection) throws SQLException, NoSuchFieldException, InstantiationException, IllegalAccessException {
        LazyTableEndpoint lazyTableEndpoint = LazyTableUtil.analyzeLazyTable(entityClass);
        perfect(connection, entityClass, DDLAuto.UPDATE);

        log.warn("perfect table {} success", lazyTableEndpoint.getTableName());
    }
}
