package com.wu.framework.inner.lazy.database.expand.database.persistence.method.dml;

import com.wu.framework.inner.layer.stereotype.LayerField;
import com.wu.framework.inner.lazy.config.LazyOperationConfig;
import com.wu.framework.inner.lazy.database.expand.database.persistence.domain.PersistenceRepository;
import com.wu.framework.inner.lazy.database.expand.database.persistence.domain.PersistenceRepositoryFactory;
import com.wu.framework.inner.lazy.database.expand.database.persistence.method.AbstractLazyOperationMethod;
import com.wu.framework.inner.lazy.database.expand.database.persistence.stream.LambdaTableType;
import com.wu.framework.inner.lazy.factory.LazyTableStructureConverterFactory;
import com.wu.framework.inner.lazy.factory.LazyTableUpsertConverterFactory;
import com.wu.framework.inner.lazy.persistence.conf.LazyTableEndpoint;
import com.wu.framework.inner.lazy.persistence.conf.LazyTableFieldEndpoint;
import com.wu.framework.inner.lazy.persistence.conf.LazyTableStructure;
import com.wu.framework.inner.lazy.persistence.util.LazyTableUtil;
import lombok.extern.slf4j.Slf4j;
import org.springframework.beans.factory.config.BeanDefinition;
import org.springframework.context.annotation.Role;
import org.springframework.util.ObjectUtils;

import java.sql.*;
import java.util.Collection;
import java.util.List;
import java.util.concurrent.ConcurrentHashMap;

/**
 * @author : Jia wei Wu
 * @version 1.0
 * describe : 灵活更新 去除null的字段、创建表
 * @date : 2020/7/3 下午10:28
 */
@Slf4j
@Role(BeanDefinition.ROLE_INFRASTRUCTURE)
public class LazyOperationMethodSmartUpsert extends AbstractLazyOperationMethod {

    private final LazyOperationConfig operationConfig;

    public LazyOperationMethodSmartUpsert(LazyOperationConfig operationConfig) {
        this.operationConfig = operationConfig;
    }


    /**
     * description 通过参数获取持久性存储库对象
     *
     * @param param 反射传过来的对象
     * @return PersistenceRepository 持久性存储库对象
     * @author Jia wei Wu
     * @date 2021/4/17 3:38 下午
     **/
    @Override
    public PersistenceRepository analyzePersistenceRepository(Object param) throws IllegalArgumentException {
        String sql = LazyTableUpsertConverterFactory.upsertRemoveNull(param);

        PersistenceRepository persistenceRepository = PersistenceRepositoryFactory.create(operationConfig);
        persistenceRepository.setExecutionType(LambdaTableType.SMART_UPSERT);
        persistenceRepository.setQueryString(sql);
        return persistenceRepository;
    }

    /**
     * description 执行SQL 语句
     *
     * @param connection
     * @param sourceParams
     * @return
     * @params
     * @author Jia wei Wu
     * @date 2020/11/22 上午11:02
     */
    @Override
    public Object execute(Connection connection, Object[] sourceParams) throws Exception {

        /**
         * 多线程执行表结构是否已经初始化 临时存储
         */
        final ConcurrentHashMap<Class, Boolean> perfectTableConcurrentHashMap = new ConcurrentHashMap<>(20);
        // 获取代理方法的第一个对象
        Object param = sourceParams[0];
        if (param instanceof Object[]) {
            Object[] objects = (Object[]) param;
            // 是否修改
            for (Object o : objects) {
                if (Collection.class.isAssignableFrom(o.getClass())) {
                    Collection collection = (Collection) o;
                    for (Object item : collection) {
                        if (!perfectTableConcurrentHashMap.containsKey(item.getClass())) {
                            final LazyTableStructure lazyTableStructure = LazyTableStructureConverterFactory.dataStructure(item);
                            perfect(connection, lazyTableStructure.schema());
                            perfectTableConcurrentHashMap.put(item.getClass(), true);
                        }
                        Object generatedKey = accurateExecution(connection, item);
                    }
                    log.warn("使用灵活更新、去除null、创建表 插入的对象数据是时list 消耗性能，建议初始化表后使用upsert方法操作！");
                } else {
                    if (!perfectTableConcurrentHashMap.containsKey(o.getClass())) {
                        final LazyTableStructure lazyTableStructure = LazyTableStructureConverterFactory.dataStructure(o);
                        perfect(connection, lazyTableStructure.schema());
                        perfectTableConcurrentHashMap.put(o.getClass(), true);
                    }
                    Object generatedKey = accurateExecution(connection, o);
                }

            }
        } else {
            final LazyTableStructure lazyTableStructure = LazyTableStructureConverterFactory.dataStructure(param);
            perfect(connection, lazyTableStructure.schema());
            Object generatedKey = accurateExecution(connection, param);

        }
//        perfectTableConcurrentHashMap.clear();
        return sourceParams;
    }

    /**
     * @param connection 数据源
     * @param param      单个对象或是单条记录
     * @return describe 精准执行
     * @author Jia wei Wu
     * @date 2021/4/18 10:13 上午
     **/
    @Override
    public Object accurateExecution(Connection connection, Object param) throws Exception {

        LazyTableEndpoint lazyTableEndpoint = LazyTableUtil.analyzeLazyTable(param.getClass());
        List<LazyTableFieldEndpoint> lazyTableFieldEndpoints = lazyTableEndpoint.specifiedFieldAnnotation(LayerField.LayerFieldType.ID);
        PersistenceRepository persistenceRepository = analyzePersistenceRepository(param);
        String queryString = persistenceRepository.getQueryString();
        PreparedStatement preparedStatement;
        if (ObjectUtils.isEmpty(lazyTableFieldEndpoints)) {
            preparedStatement = connection.prepareStatement(queryString);
        } else {
            // 会创建id自增
            preparedStatement = connection.prepareStatement(queryString, Statement.RETURN_GENERATED_KEYS);
        }

        try {
            preparedStatement.execute();

            String generatedKey = "0";
            if (!ObjectUtils.isEmpty(lazyTableFieldEndpoints)) {
                ResultSet resultSet = preparedStatement.getGeneratedKeys();
                if (resultSet.next()) {
                    generatedKey = resultSet.getString(1);
                }

                // 只会有一个
                LazyTableFieldEndpoint fieldEndpoint = lazyTableFieldEndpoints.get(0);
                Class clazz = fieldEndpoint.getClazz();
                Object id = null;
                if (Integer.class.equals(clazz)) {
                    id = Integer.valueOf(generatedKey);
                } else if (int.class.equals(clazz)) {
                    id = Integer.valueOf(generatedKey);
                } else if (Long.class.equals(clazz)) {
                    id = Long.valueOf(generatedKey);
                } else if (long.class.equals(clazz)) {
                    id = Long.valueOf(generatedKey);
                } else if (String.class.equals(clazz)) {
                    id = generatedKey;
                }
                fieldEndpoint.getField().set(param, id);
            }

            return generatedKey;
        } catch (SQLException sqlException) {
            throw new SQLException(queryString, sqlException);
        } finally {
            preparedStatement.close();
        }
    }

}
