package com.wu.framework.inner.lazy.database.expand.database.persistence.proxy;

import com.wu.framework.inner.database.dynamic.toolkit.DynamicLazyDSContextHolder;
import com.wu.framework.inner.layer.stereotype.proxy.AbstractProxyRetryInvocationHandler;
import com.wu.framework.inner.lazy.persistence.conf.LazyDynamicEndpoint;
import lombok.extern.slf4j.Slf4j;
import org.springframework.util.ObjectUtils;

import javax.sql.DataSource;
import java.lang.reflect.Method;
import java.sql.Connection;
import java.sql.SQLException;

/**
 * description LazyOperationProxy 抽象类
 * 下游DDL代理、DQL代理、DML代理
 *
 * @author 吴佳伟
 * @date 2023/01/15 21:58
 */
@Slf4j
public abstract class AbstractLazyOperationProxyRetryInvocationHandler extends AbstractProxyRetryInvocationHandler {


    /**
     * description: 确定数据源头
     *
     * @param
     * @return
     * @author 吴佳伟
     * @date: 15.1.23 22:03
     */
    public abstract DataSource determineConnection() throws SQLException;

    public void afterInvoke() {
        DynamicLazyDSContextHolder.clear();
    }

    @Override
    public Object invoke(Object proxy, Method method, Object[] args) throws Throwable {
        if (Object.class.equals(method.getDeclaringClass())) {
            return method.invoke(this, args);
        }
        Object retryInvoke = retryInvoke(proxy, method, args, 1, null);
        // invoke 后的操作
        afterInvoke();
        return retryInvoke;
    }

    /**
     * 切换数据库
     *
     * @param connection 链接对象
     */
    public Connection switchSchema(Connection connection) {
        LazyDynamicEndpoint ds = DynamicLazyDSContextHolder.peek();
        if (null != ds && !ObjectUtils.isEmpty(ds.getSchema())) {
            String schema = ds.getSchema();
            try {
                connection.setSchema(schema);
                log.debug("切换schema:【{}】 成功", schema);
            } catch (SQLException e) {
                e.printStackTrace();
                log.error("切换数据库失败:【{}】", e.getMessage());
            }
        }
        return connection;
    }
}
