/*
 * Decompiled with CFR 0.152.
 */
package com.wu.framework.inner.lazy.database.expand.database.persistence.factory;

import com.wu.framework.inner.database.dynamic.LazyDynamicAdapter;
import com.wu.framework.inner.database.dynamic.factory.LazyDynamicAdapterFactory;
import com.wu.framework.inner.lazy.config.LazyOperationConfig;
import com.wu.framework.inner.lazy.config.prop.LazyDataSourceProperties;
import com.wu.framework.inner.lazy.database.expand.database.persistence.LazyOperation;
import com.wu.framework.inner.lazy.database.expand.database.persistence.method.LazyOperationMethod;
import com.wu.framework.inner.lazy.database.expand.database.persistence.method.LazyOperationMethodExecute;
import com.wu.framework.inner.lazy.database.expand.database.persistence.method.LazyOperationMethodExecuteOne;
import com.wu.framework.inner.lazy.database.expand.database.persistence.method.LazyOperationMethodExecuteSQL;
import com.wu.framework.inner.lazy.database.expand.database.persistence.method.LazyOperationMethodExecuteSQLForBean;
import com.wu.framework.inner.lazy.database.expand.database.persistence.method.LazyOperationMethodInsert;
import com.wu.framework.inner.lazy.database.expand.database.persistence.method.LazyOperationMethodPage;
import com.wu.framework.inner.lazy.database.expand.database.persistence.method.LazyOperationMethodSmartUpsert;
import com.wu.framework.inner.lazy.database.expand.database.persistence.proxy.LazyOperationProxy;
import java.lang.reflect.InvocationHandler;
import java.lang.reflect.Proxy;
import java.util.Arrays;
import java.util.List;
import org.springframework.context.ApplicationContext;

public final class LazyOperationProxyFactory {
    public static LazyOperationProxy createDefaultLazyOperationProxy(LazyDataSourceProperties sourceProperties) {
        return LazyOperationProxyFactory.createDefaultLazyOperationProxy(sourceProperties, null);
    }

    public static LazyOperationProxy createDefaultLazyOperationProxy(LazyDataSourceProperties sourceProperties, LazyOperationConfig lazyOperationConfig) {
        List<LazyOperationMethod> lazyOperationMethods = Arrays.asList(new LazyOperationMethodExecute(), new LazyOperationMethodExecuteOne(), new LazyOperationMethodInsert(lazyOperationConfig), new LazyOperationMethodPage(lazyOperationConfig), new LazyOperationMethodExecuteSQL(lazyOperationConfig), new LazyOperationMethodExecuteSQLForBean(lazyOperationConfig), new LazyOperationMethodSmartUpsert(lazyOperationConfig));
        return LazyOperationProxyFactory.createLazyOperationProxy(null, sourceProperties, lazyOperationMethods);
    }

    public static LazyOperationProxy createLazyOperationProxy(LazyDataSourceProperties sourceProperties, List<LazyOperationMethod> lazyOperationMethods) {
        return LazyOperationProxyFactory.createLazyOperationProxy(null, sourceProperties, lazyOperationMethods);
    }

    public static LazyOperationProxy createLazyOperationProxy(ApplicationContext applicationContext, LazyDataSourceProperties sourceProperties, List<LazyOperationMethod> lazyOperationMethods) {
        LazyDynamicAdapter lazyDynamicAdapter = LazyDynamicAdapterFactory.createLazyDynamicAdapter((ApplicationContext)applicationContext, (LazyDataSourceProperties)sourceProperties);
        LazyOperationProxy lazyOperationProxy = new LazyOperationProxy(lazyOperationMethods, lazyDynamicAdapter);
        try {
            lazyOperationProxy.afterPropertiesSet();
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
        return lazyOperationProxy;
    }

    public static LazyOperation createLazyOperation(LazyDataSourceProperties lazyDataSourceProperties) {
        LazyOperationProxy defaultLazyOperationProxy = LazyOperationProxyFactory.createDefaultLazyOperationProxy(lazyDataSourceProperties);
        return LazyOperationProxyFactory.createLazyOperation(defaultLazyOperationProxy);
    }

    public static LazyOperation createLazyOperation(LazyOperationProxy lazyOperationProxy) {
        return (LazyOperation)Proxy.newProxyInstance(LazyOperation.class.getClassLoader(), new Class[]{LazyOperation.class}, (InvocationHandler)lazyOperationProxy);
    }

    public static LazyOperation createLazyOperation(String url, String username, String password) {
        LazyDataSourceProperties lazyDataSourceProperties = new LazyDataSourceProperties();
        lazyDataSourceProperties.setUrl(url);
        lazyDataSourceProperties.setUsername(username);
        lazyDataSourceProperties.setPassword(password);
        return LazyOperationProxyFactory.createLazyOperation(lazyDataSourceProperties);
    }

    public static LazyOperation createLazyOperation(String host, int port, String schema, String username, String password) {
        String urlFormat = "jdbc:mysql://%s:%s/%s?useUnicode=true&characterEncoding=utf-8&useSSL=true&allowMultiQueries=true&serverTimezone=Asia/Shanghai";
        String url = String.format(urlFormat, host, port, schema);
        return LazyOperationProxyFactory.createLazyOperation(url, username, password);
    }
}

