/*
 * Decompiled with CFR 0.152.
 */
package com.wu.framework.inner.lazy.database.expand.database.persistence.factory.config;

import com.wu.framework.inner.lazy.config.LazyOperationConfig;
import com.wu.framework.inner.lazy.config.enums.DDLAuto;
import com.wu.framework.inner.lazy.database.expand.database.persistence.LazyOperation;
import com.wu.framework.inner.lazy.persistence.util.ScanClassUtil;
import com.wu.framework.inner.lazy.stereotype.LazyScan;
import java.util.List;
import org.springframework.beans.BeansException;
import org.springframework.beans.factory.config.BeanPostProcessor;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.core.Ordered;
import org.springframework.core.annotation.AnnotatedElementUtils;
import org.springframework.util.ObjectUtils;

@ConditionalOnProperty(prefix="spring.datasource", value={"url"})
public class LazyBeanPostProcessor
implements BeanPostProcessor,
Ordered {
    private final LazyOperation operation;
    private final LazyOperationConfig operationConfig;

    public LazyBeanPostProcessor(LazyOperation operation, LazyOperationConfig operationConfig) {
        this.operation = operation;
        this.operationConfig = operationConfig;
    }

    public Object postProcessBeforeInitialization(Object bean, String beanName) throws BeansException {
        DDLAuto ddlAuto = this.operationConfig.getDdlConfigure().getDdlAuto();
        if (AnnotatedElementUtils.hasAnnotation(bean.getClass(), LazyScan.class)) {
            List classes;
            LazyScan lazyScan = (LazyScan)AnnotatedElementUtils.findMergedAnnotation(bean.getClass(), LazyScan.class);
            Object[] scanBasePackages = lazyScan.scanBasePackages();
            Object[] scanBasePackageClasses = lazyScan.scanBasePackageClasses();
            if (!ObjectUtils.isEmpty((Object[])scanBasePackages)) {
                for (Object scanBasePackage : scanBasePackages) {
                    classes = ScanClassUtil.scanClass((String)scanBasePackage, null);
                    for (Class clazz : classes) {
                        if (DDLAuto.CREATE.equals((Object)ddlAuto)) {
                            this.operation.createTable(clazz);
                            continue;
                        }
                        if (DDLAuto.UPDATE.equals((Object)ddlAuto)) {
                            this.operation.updateTable(clazz);
                            continue;
                        }
                        if (!DDLAuto.PERFECT.equals((Object)ddlAuto)) continue;
                        this.operation.perfect(clazz);
                    }
                }
            }
            if (!ObjectUtils.isEmpty((Object[])scanBasePackageClasses)) {
                for (Object scanBasePackageClass : scanBasePackageClasses) {
                    classes = ScanClassUtil.scanClass((String)((Class)scanBasePackageClass).getPackage().getName(), null);
                    for (Class clazz : classes) {
                        if (DDLAuto.CREATE.equals((Object)ddlAuto)) {
                            this.operation.createTable(clazz);
                            continue;
                        }
                        if (DDLAuto.UPDATE.equals((Object)ddlAuto)) {
                            this.operation.updateTable(clazz);
                            continue;
                        }
                        if (!DDLAuto.PERFECT.equals((Object)ddlAuto)) continue;
                        this.operation.perfect(clazz);
                    }
                }
            }
        }
        return super.postProcessBeforeInitialization(bean, beanName);
    }

    public Object postProcessAfterInitialization(Object bean, String beanName) throws BeansException {
        return super.postProcessAfterInitialization(bean, beanName);
    }

    public int getOrder() {
        return 0;
    }
}

