/*
 * Decompiled with CFR 0.152.
 */
package com.wu.framework.inner.lazy.database.expand.database.persistence.method;

import com.wu.framework.inner.lazy.config.LazyOperationConfig;
import com.wu.framework.inner.lazy.database.expand.database.persistence.domain.PersistenceRepository;
import com.wu.framework.inner.lazy.database.expand.database.persistence.domain.PersistenceRepositoryFactory;
import com.wu.framework.inner.lazy.database.expand.database.persistence.method.AbstractLazyOperationMethod;
import com.wu.framework.inner.lazy.database.expand.database.persistence.stream.LambdaTableType;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.Arrays;
import java.util.List;
import org.springframework.stereotype.Component;
import org.springframework.util.ObjectUtils;

@Component
public class LazyOperationMethodExecuteSQL
extends AbstractLazyOperationMethod {
    private final LazyOperationConfig operationConfig;

    public LazyOperationMethodExecuteSQL(LazyOperationConfig operationConfig) {
        this.operationConfig = operationConfig;
    }

    @Override
    public PersistenceRepository analyzePersistenceRepository(Object param) throws IllegalArgumentException {
        Object[] p = (Object[])param;
        String sourceSql = (String)p[0];
        Class clazz = (Class)p[1];
        Object[] params = (Object[])p[2];
        String sql = ObjectUtils.isEmpty((Object[])params) ? sourceSql : String.format(sourceSql, params);
        PersistenceRepository persistenceRepository = PersistenceRepositoryFactory.create((LazyOperationConfig)this.operationConfig);
        if (sql.contains(LambdaTableType.DELETE.getValue())) {
            persistenceRepository.setExecutionType(LambdaTableType.DELETE);
        }
        if (sql.contains(LambdaTableType.INSERT.getValue())) {
            persistenceRepository.setExecutionType(LambdaTableType.INSERT);
        }
        if (sql.contains(LambdaTableType.UPDATE.getValue())) {
            persistenceRepository.setExecutionType(LambdaTableType.UPDATE);
        }
        persistenceRepository.setQueryString(sql);
        persistenceRepository.setResultClass(clazz);
        return persistenceRepository;
    }

    @Override
    public Object execute(Connection connection, Object[] sourceParams) throws SQLException, NoSuchFieldException, InstantiationException, IllegalAccessException {
        PersistenceRepository persistenceRepository = this.analyzePersistenceRepository(sourceParams);
        try (PreparedStatement preparedStatement = connection.prepareStatement(persistenceRepository.getQueryString());){
            if (persistenceRepository.getExecutionType().equals((Object)LambdaTableType.SELECT)) {
                List result;
                ResultSet resultSet = preparedStatement.executeQuery();
                List list = result = this.resultSetConverter(resultSet, persistenceRepository.getResultType());
                return list;
            }
            int update = preparedStatement.executeUpdate();
            List<Integer> list = Arrays.asList(update);
            return list;
        }
    }
}

