/*
 * Decompiled with CFR 0.152.
 */
package com.wu.framework.inner.lazy.database.expand.database.persistence.method;

import com.wu.framework.inner.lazy.config.LazyOperationConfig;
import com.wu.framework.inner.lazy.database.expand.database.persistence.domain.Persistence;
import com.wu.framework.inner.lazy.database.expand.database.persistence.domain.PersistenceRepository;
import com.wu.framework.inner.lazy.database.expand.database.persistence.domain.PersistenceRepositoryFactory;
import com.wu.framework.inner.lazy.database.expand.database.persistence.factory.LazyTableStructureConverterFactory;
import com.wu.framework.inner.lazy.database.expand.database.persistence.method.AbstractLazyOperationMethod;
import com.wu.framework.inner.lazy.persistence.conf.LazyDatabaseJsonMessage;
import com.wu.framework.inner.lazy.persistence.conf.LazyTableEndpoint;
import com.wu.framework.inner.lazy.persistence.conf.LazyTableStructure;
import com.wu.framework.inner.lazy.stereotype.LazyTableFieldId;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.util.List;
import java.util.Locale;
import java.util.stream.Collectors;
import org.springframework.stereotype.Component;
import org.springframework.util.ObjectUtils;

@Component
public class LazyOperationMethodInsert
extends AbstractLazyOperationMethod {
    private final LazyOperationConfig operationConfig;

    public LazyOperationMethodInsert(LazyOperationConfig operationConfig) {
        this.operationConfig = operationConfig;
    }

    @Override
    public PersistenceRepository analyzePersistenceRepository(Object insert) throws Exception {
        LazyTableStructure lazyTableStructure = LazyTableStructureConverterFactory.dataStructure(insert);
        LazyTableEndpoint endpoint = lazyTableStructure.schema();
        List payload = lazyTableStructure.payload();
        String tableName = endpoint.getTableName();
        String schema = endpoint.getSchema();
        StringBuffer stringBuffer = new StringBuffer(Persistence.ExecutionEnum.INSERT.getExecution());
        if (ObjectUtils.isEmpty((Object)schema)) {
            stringBuffer.append(tableName);
        } else {
            stringBuffer.append(schema + "." + tableName);
        }
        stringBuffer.append("(");
        stringBuffer.append(endpoint.getFieldEndpoints().stream().filter(fieldLazyTableFieldEndpoint -> !LazyTableFieldId.IdType.AUTOMATIC_ID.equals((Object)fieldLazyTableFieldEndpoint.getIdType())).map(fieldLazyTableFieldEndpoint -> {
            String columnName = fieldLazyTableFieldEndpoint.getColumnName();
            if (LazyDatabaseJsonMessage.specialFields.contains(columnName.toUpperCase(Locale.ROOT))) {
                return "`" + columnName + "`";
            }
            return columnName;
        }).collect(Collectors.joining(",")));
        stringBuffer.append(")");
        stringBuffer.append("values");
        stringBuffer.append(payload.stream().map(item -> "(" + item.stream().map(o -> null == o ? null : "'" + o + "'").collect(Collectors.joining(",")) + ")").collect(Collectors.joining(",")));
        String sql = stringBuffer.toString();
        PersistenceRepository persistenceRepository = PersistenceRepositoryFactory.create((LazyOperationConfig)this.operationConfig);
        persistenceRepository.setQueryString(sql);
        return persistenceRepository;
    }

    @Override
    public Object execute(Connection connection, Object[] sourceParams) throws Exception {
        Object param = sourceParams[0];
        if (param instanceof Object[]) {
            Object[] insertList;
            for (Object insert : insertList = (Object[])param) {
                this.accurateExecution(connection, insert);
            }
        } else {
            this.accurateExecution(connection, param);
        }
        return sourceParams.length;
    }

    @Override
    public Object accurateExecution(Connection connection, Object param) throws Exception {
        PersistenceRepository persistenceRepository = this.analyzePersistenceRepository(param);
        try (PreparedStatement preparedStatement = connection.prepareStatement(persistenceRepository.getQueryString());){
            boolean execute = preparedStatement.execute();
            Boolean bl = execute;
            return bl;
        }
    }
}

