/*
 * Decompiled with CFR 0.152.
 */
package com.wu.framework.inner.lazy.database.expand.database.persistence.method;

import com.wu.framework.inner.lazy.config.LazyOperationConfig;
import com.wu.framework.inner.lazy.database.expand.database.persistence.domain.Page;
import com.wu.framework.inner.lazy.database.expand.database.persistence.domain.PersistenceRepository;
import com.wu.framework.inner.lazy.database.expand.database.persistence.domain.PersistenceRepositoryFactory;
import com.wu.framework.inner.lazy.database.expand.database.persistence.method.AbstractLazyOperationMethod;
import com.wu.framework.inner.lazy.persistence.conf.ClassLazyTableEndpoint;
import com.wu.framework.inner.lazy.persistence.util.LazyTableUtil;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.List;
import org.springframework.stereotype.Component;

@Component
public class LazyOperationMethodPage
extends AbstractLazyOperationMethod {
    public static final String COUNT_SQL = "select count(1)  from (%s) as derived_table ";
    public static final String LIMIT_SQL = "select * from (%s) derived_table limit %s,%s ";
    private final LazyOperationConfig operationConfig;
    private String countSql;
    private String limitSql;
    private Page page;

    public LazyOperationMethodPage(LazyOperationConfig operationConfig) {
        this.operationConfig = operationConfig;
    }

    @Override
    public PersistenceRepository analyzePersistenceRepository(Object param) throws IllegalArgumentException {
        String queryString = "";
        Object[] p = (Object[])param;
        this.page = (Page)p[0];
        Class clazz = (Class)p[1];
        String sqlFormat = (String)p[2];
        Object[] params = (Object[])p[3];
        if (null == sqlFormat) {
            ClassLazyTableEndpoint lazyTableAnnotation = LazyTableUtil.analyzeLazyTable((Class)clazz);
            sqlFormat = String.format("select * from %s ", lazyTableAnnotation.getFullTableName());
        }
        String listSql = this.loadSqlParameters(sqlFormat, params);
        this.countSql = this.loadSqlParameters(COUNT_SQL, listSql);
        this.limitSql = this.loadSqlParameters(LIMIT_SQL, listSql, (this.page.getCurrent() - 1) * this.page.getSize(), this.page.getSize());
        queryString = this.countSql + ";" + this.limitSql;
        PersistenceRepository persistenceRepository = PersistenceRepositoryFactory.create((LazyOperationConfig)this.operationConfig);
        persistenceRepository.setQueryString(queryString);
        persistenceRepository.setResultClass(clazz);
        return persistenceRepository;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Object execute(Connection connection, Object[] sourceParams) throws SQLException {
        Statement statement = null;
        PersistenceRepository persistenceRepository = this.analyzePersistenceRepository(sourceParams);
        try {
            this.count(connection);
            statement = connection.createStatement();
            ResultSet resultSet = statement.executeQuery(this.limitSql);
            List result = this.resultSetConverter(resultSet, persistenceRepository.getResultType());
            this.page.setRecord(result);
            Page page = this.page;
            return page;
        }
        catch (IllegalAccessException | InstantiationException | NoSuchFieldException | SQLException exception) {
            exception.printStackTrace();
        }
        finally {
            assert (statement != null);
            statement.close();
        }
        return this.page;
    }

    private void count(Connection connection) throws SQLException, NoSuchFieldException, InstantiationException, IllegalAccessException {
        PreparedStatement countPreparedStatement = connection.prepareStatement(this.countSql);
        ResultSet resultSet = countPreparedStatement.executeQuery();
        List<Long> objects = this.resultSetConverter(resultSet, Long.class);
        long total = objects.get(0);
        long pages = (total + (long)this.page.getSize() + 1L) / (long)this.page.getSize();
        this.page.setTotal(total);
        this.page.setPages(pages);
        countPreparedStatement.close();
    }
}

