/*
 * Decompiled with CFR 0.152.
 */
package com.wu.framework.inner.lazy.database.expand.database.persistence.method;

import com.wu.framework.inner.layer.CamelAndUnderLineConverter;
import com.wu.framework.inner.layer.stereotype.LayerField;
import com.wu.framework.inner.layer.util.BinHexSwitchUtil;
import com.wu.framework.inner.lazy.config.LazyOperationConfig;
import com.wu.framework.inner.lazy.database.expand.database.persistence.domain.Persistence;
import com.wu.framework.inner.lazy.database.expand.database.persistence.domain.PersistenceRepository;
import com.wu.framework.inner.lazy.database.expand.database.persistence.domain.PersistenceRepositoryFactory;
import com.wu.framework.inner.lazy.database.expand.database.persistence.method.AbstractLazyOperationMethod;
import com.wu.framework.inner.lazy.persistence.analyze.DefaultMySQLDataProcessAnalyze;
import com.wu.framework.inner.lazy.persistence.conf.ClassLazyTableEndpoint;
import com.wu.framework.inner.lazy.persistence.conf.FieldLazyTableFieldEndpoint;
import com.wu.framework.inner.lazy.persistence.conf.LazyDatabaseJsonMessage;
import com.wu.framework.inner.lazy.persistence.map.EasyHashMap;
import com.wu.framework.inner.lazy.persistence.util.LazyTableUtil;
import com.wu.framework.inner.lazy.persistence.util.MySQLUtil;
import com.wu.framework.inner.lazy.stereotype.LazyTableField;
import java.lang.reflect.AnnotatedElement;
import java.lang.reflect.Field;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Locale;
import java.util.stream.Collectors;
import org.springframework.core.annotation.AnnotatedElementUtils;
import org.springframework.stereotype.Component;
import org.springframework.util.ObjectUtils;

@Component
public class LazyOperationMethodUpsertRemoveNull
extends AbstractLazyOperationMethod {
    private final DefaultMySQLDataProcessAnalyze defaultMySQLDataProcessAnalyze = new DefaultMySQLDataProcessAnalyze();
    private final LazyOperationConfig operationConfig;

    public LazyOperationMethodUpsertRemoveNull(LazyOperationConfig operationConfig) {
        this.operationConfig = operationConfig;
    }

    @Override
    public PersistenceRepository analyzePersistenceRepository(Object param) throws IllegalArgumentException {
        Persistence persistence = this.smartUpsert(param);
        StringBuffer stringBuffer = new StringBuffer(persistence.getExecutionEnum().getExecution());
        stringBuffer.append(persistence.getTableName());
        stringBuffer.append("(");
        stringBuffer.append(String.join((CharSequence)",", persistence.getColumnList()));
        stringBuffer.append(") values ( ");
        stringBuffer.append(persistence.getCondition());
        stringBuffer.append(" )ON DUPLICATE KEY UPDATE ");
        stringBuffer.append(persistence.getColumnList().stream().map(s -> s + " " + "=" + "values" + " " + "(" + s + ")").collect(Collectors.joining(",")));
        String sql = stringBuffer.toString();
        PersistenceRepository persistenceRepository = PersistenceRepositoryFactory.create((LazyOperationConfig)this.operationConfig);
        persistenceRepository.setQueryString(sql);
        return persistenceRepository;
    }

    @Override
    public Object execute(Connection connection, Object[] sourceParams) throws Exception {
        Object param = sourceParams[0];
        if (param instanceof Object[]) {
            Object[] objects;
            for (Object o : objects = (Object[])param) {
                if (Collection.class.isAssignableFrom(o.getClass())) {
                    Collection collection = (Collection)o;
                    for (Object item : collection) {
                        Object object = this.accurateExecution(connection, item);
                    }
                    this.log.warn("\u4f7f\u7528\u7075\u6d3b\u66f4\u65b0\u3001\u53bb\u9664null\u3001\u521b\u5efa\u8868 \u63d2\u5165\u7684\u5bf9\u8c61\u6570\u636e\u662f\u65f6list \u6d88\u8017\u6027\u80fd\uff0c\u5efa\u8bae\u521d\u59cb\u5316\u8868\u540e\u4f7f\u7528upsert\u65b9\u6cd5\u64cd\u4f5c\uff01");
                    continue;
                }
                Object object = this.accurateExecution(connection, o);
            }
        } else {
            Object object = this.accurateExecution(connection, param);
        }
        return sourceParams;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Object accurateExecution(Connection connection, Object param) throws Exception {
        ClassLazyTableEndpoint classLazyTableEndpoint = LazyTableUtil.analyzeLazyTable(param.getClass());
        List lazyTableFieldEndpoints = classLazyTableEndpoint.specifiedFieldAnnotation(LayerField.LayerFieldType.ID);
        PersistenceRepository persistenceRepository = this.analyzePersistenceRepository(param);
        try (PreparedStatement preparedStatement = ObjectUtils.isEmpty((Object)lazyTableFieldEndpoints) ? connection.prepareStatement(persistenceRepository.getQueryString()) : connection.prepareStatement(persistenceRepository.getQueryString(), 1);){
            preparedStatement.execute();
            String generatedKey = "0";
            if (!ObjectUtils.isEmpty((Object)lazyTableFieldEndpoints)) {
                ResultSet resultSet = preparedStatement.getGeneratedKeys();
                if (resultSet.next()) {
                    generatedKey = resultSet.getString(1);
                }
                FieldLazyTableFieldEndpoint fieldEndpoint = (FieldLazyTableFieldEndpoint)lazyTableFieldEndpoints.get(0);
                Class clazz = fieldEndpoint.getClazz();
                Object id = null;
                if (Integer.class.equals((Object)clazz)) {
                    id = Integer.valueOf(generatedKey);
                } else if (Integer.TYPE.equals(clazz)) {
                    id = Integer.valueOf(generatedKey);
                } else if (Long.class.equals((Object)clazz)) {
                    id = Long.valueOf(generatedKey);
                } else if (Long.TYPE.equals(clazz)) {
                    id = Long.valueOf(generatedKey);
                } else if (String.class.equals((Object)clazz)) {
                    id = generatedKey;
                }
                fieldEndpoint.getField().set(param, id);
            }
            String string = generatedKey;
            return string;
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public Persistence smartUpsert(Object object) {
        ArrayList<String> columnList = new ArrayList<String>();
        ArrayList<String> columnValueList = new ArrayList<String>();
        Class<?> aClass = object.getClass();
        String tableName = LazyTableUtil.getTableName(aClass);
        if (EasyHashMap.class.isAssignableFrom(aClass)) {
            EasyHashMap easyHashMap = (EasyHashMap)object;
            if (!easyHashMap.isModifyUniqueLabel()) throw new IllegalAccessException("\u81ea\u52a8\u521b\u5efa\u7684uniqueLabel \u65e0\u6cd5\u88ab\u4f7f\u7528\u4e3a\u8868\u540d " + easyHashMap.getUniqueLabel());
            tableName = easyHashMap.getUniqueLabel();
            easyHashMap.forEach((key, value) -> {
                if (!ObjectUtils.isEmpty((Object)value)) {
                    if (LazyDatabaseJsonMessage.specialFields.contains(key.toString().toUpperCase(Locale.ROOT))) {
                        columnList.add("`" + key + "`");
                    } else {
                        columnList.add(key.toString());
                    }
                    byte[] binary = this.defaultMySQLDataProcessAnalyze.isBinary(value);
                    if (ObjectUtils.isEmpty((Object)binary)) {
                        columnValueList.add("'" + value + "'");
                    } else {
                        columnValueList.add(BinHexSwitchUtil.bytesToHexSql((byte[])binary));
                    }
                }
            });
            return new Persistence().setExecutionEnum(Persistence.ExecutionEnum.INSERT).setTableName(tableName).setColumnList(columnList).setCondition(String.join((CharSequence)",", columnValueList));
        } else {
            for (Field declaredField : aClass.getDeclaredFields()) {
                String column;
                LazyTableField tableField;
                declaredField.setAccessible(true);
                Object o = declaredField.get(object);
                if (o == null || (tableField = (LazyTableField)AnnotatedElementUtils.findMergedAnnotation((AnnotatedElement)declaredField, LazyTableField.class)) != null && !tableField.exist()) continue;
                String string = column = ObjectUtils.isEmpty((Object)tableField) || ObjectUtils.isEmpty((Object)tableField.name()) ? CamelAndUnderLineConverter.humpToLine2((String)declaredField.getName()) : tableField.name();
                if (LazyDatabaseJsonMessage.specialFields.contains(column.toUpperCase(Locale.ROOT))) {
                    columnList.add("`" + column + "`");
                } else {
                    columnList.add(column);
                }
                byte[] binary = MySQLUtil.isBinary((Object)o);
                if (ObjectUtils.isEmpty((Object)binary)) {
                    Object columnData = MySQLUtil.convertValueToMysqlColumnData((Object)o);
                    columnValueList.add(ObjectUtils.isEmpty((Object)columnData) ? null : columnData.toString());
                    continue;
                }
                columnValueList.add(BinHexSwitchUtil.bytesToHexSql((byte[])binary));
            }
        }
        return new Persistence().setExecutionEnum(Persistence.ExecutionEnum.INSERT).setTableName(tableName).setColumnList(columnList).setCondition(String.join((CharSequence)",", columnValueList));
    }
}

