/*
 * Decompiled with CFR 0.152.
 */
package com.wu.framework.inner.lazy.database.expand.database.persistence.proxy;

import com.wu.framework.inner.layer.stereotype.proxy.ProxyStrategicApproach;
import com.wu.framework.inner.lazy.database.expand.database.persistence.method.LazyOperationMethod;
import java.lang.reflect.AnnotatedElement;
import java.lang.reflect.InvocationHandler;
import java.lang.reflect.Method;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.sql.DataSource;
import org.springframework.beans.factory.InitializingBean;
import org.springframework.boot.autoconfigure.condition.ConditionalOnBean;
import org.springframework.core.annotation.AnnotatedElementUtils;

@ConditionalOnBean(value={DataSource.class})
public class PerfectLazyOperationProxy
implements InvocationHandler,
InitializingBean {
    private static final Map<Class<? extends LazyOperationMethod>, LazyOperationMethod> LAZY_OPERATION_METHOD_MAP = new HashMap<Class<? extends LazyOperationMethod>, LazyOperationMethod>();
    private final DataSource dataSource;
    private final List<LazyOperationMethod> lazyOperationMethods;

    public PerfectLazyOperationProxy(DataSource dataSource, List<LazyOperationMethod> lazyOperationMethods) {
        this.dataSource = dataSource;
        this.lazyOperationMethods = lazyOperationMethods;
    }

    @Override
    public Object invoke(Object proxy, Method method, Object[] args) throws Throwable {
        ProxyStrategicApproach mergedAnnotation = (ProxyStrategicApproach)AnnotatedElementUtils.findMergedAnnotation((AnnotatedElement)method, ProxyStrategicApproach.class);
        if (null != mergedAnnotation) {
            LazyOperationMethod lazyOperationMethod = LAZY_OPERATION_METHOD_MAP.get(mergedAnnotation.proxyClass());
            return lazyOperationMethod.execute(this.dataSource, args);
        }
        return method.invoke((Object)this, args);
    }

    public void afterPropertiesSet() throws Exception {
        this.lazyOperationMethods.stream().forEach(lazyOperationMethod -> LAZY_OPERATION_METHOD_MAP.put((Class<? extends LazyOperationMethod>)lazyOperationMethod.getClass(), (LazyOperationMethod)lazyOperationMethod));
    }
}

